/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.config.PolymorphicConfiguration;
import io.bootique.config.TypesFactory;
import io.bootique.log.BootLogger;
import io.bootique.log.DefaultBootLogger;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

public class PolymorphicConfigurationChecker<T extends PolymorphicConfiguration> {
    private Class<T> expectedRoot;
    private Class<? extends T> expectedDefault;
    private Set<Class<? extends T>> allExpectedTypes;

    @SafeVarargs
    protected PolymorphicConfigurationChecker(Class<T> expectedRoot, Class<? extends T> expectedDefault, Class<? extends T> ... otherConfigs) {
        this.expectedRoot = Objects.requireNonNull(expectedRoot);
        this.expectedDefault = expectedDefault;
        HashSet<Class<T>> allTypes = new HashSet<Class<T>>();
        allTypes.add(Objects.requireNonNull(expectedRoot));
        if (expectedDefault != null) {
            allTypes.add(expectedDefault);
        }
        if (otherConfigs != null) {
            allTypes.addAll(Arrays.asList(otherConfigs));
        }
        this.allExpectedTypes = allTypes;
    }

    @SafeVarargs
    public static <T extends PolymorphicConfiguration> void test(Class<T> expectedRoot, Class<? extends T> expectedDefault, Class<? extends T> ... otherConfigs) {
        new PolymorphicConfigurationChecker<T>(expectedRoot, expectedDefault, otherConfigs).test();
    }

    @SafeVarargs
    public static <T extends PolymorphicConfiguration> void testNoDefault(Class<T> expectedRoot, Class<? extends T> ... otherConfigs) {
        new PolymorphicConfigurationChecker<T>(expectedRoot, null, otherConfigs).test();
    }

    protected void test() {
        Set<Class<PolymorphicConfiguration>> loaded = this.loadedFromSpi();
        Assertions.assertEquals(this.allExpectedTypes, loaded, (String)"Loaded and expected types do not match");
        this.testRoot();
        this.allExpectedTypes.forEach(t -> {
            if (!t.equals(this.expectedRoot)) {
                this.testNonRoot((Class<? extends T>)t);
            }
        });
    }

    protected void testRoot() {
        Assertions.assertTrue((boolean)PolymorphicConfiguration.class.isAssignableFrom(this.expectedRoot), (String)("Invalid root type: " + this.expectedRoot));
        JsonTypeInfo typeInfo = this.expectedRoot.getAnnotation(JsonTypeInfo.class);
        Assertions.assertNotNull((Object)typeInfo, (String)"Root is not annotated with @JsonTypeInfo");
        if (this.expectedDefault != null) {
            Assertions.assertTrue((boolean)this.hasDefault(typeInfo), (String)("Default type is not specified on root. Expected: " + this.expectedDefault.getName()));
            Assertions.assertEquals(this.expectedDefault, (Object)typeInfo.defaultImpl(), (String)"Expected and actual default types are not the same");
        } else {
            Assertions.assertFalse((boolean)this.hasDefault(typeInfo), (String)("Expected no default type, but @JsonTypeInfo sets it to " + typeInfo.defaultImpl().getName() + "."));
        }
        if (this.isConcrete(this.expectedRoot)) {
            JsonTypeName typeName = this.expectedRoot.getAnnotation(JsonTypeName.class);
            Assertions.assertNotNull((Object)typeName, (String)("Concrete root configuration type must be annotated with @JsonTypeName: " + this.expectedRoot.getName()));
        }
    }

    protected void testNonRoot(Class<? extends T> t) {
        Assertions.assertTrue((boolean)this.expectedRoot.isAssignableFrom(t), (String)("Invalid type " + t.getName() + ". Must be a subclass of root type " + this.expectedRoot.getName()));
        Assertions.assertTrue((boolean)this.isConcrete(t), (String)("Non-root configuration type must not be abstract: " + t.getName()));
        JsonTypeName typeName = t.getAnnotation(JsonTypeName.class);
        Assertions.assertNotNull((Object)typeName, (String)("Non-root configuration type must be annotated with @JsonTypeName: " + t.getName()));
    }

    protected Set<Class<? extends PolymorphicConfiguration>> loadedFromSpi() {
        Collection types;
        try {
            types = new TypesFactory(this.getClass().getClassLoader(), PolymorphicConfiguration.class, (BootLogger)new DefaultBootLogger(false)).getTypes();
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
            throw new RuntimeException(e);
        }
        return types.stream().filter(p -> this.expectedRoot.isAssignableFrom((Class<?>)p)).collect(Collectors.toSet());
    }

    protected boolean isConcrete(Class<?> type) {
        int modifiers = type.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers);
    }

    protected boolean hasDefault(JsonTypeInfo typeInfo) {
        return !typeInfo.defaultImpl().equals(JsonTypeInfo.class);
    }
}

