/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import io.bootique.junit5.InMemoryPrintStream;
import io.bootique.log.BootLogger;
import io.bootique.log.DefaultBootLogger;
import java.io.PrintStream;

public class TestIO {
    private final InMemoryPrintStream stdout;
    private final InMemoryPrintStream stderr;
    private final boolean trace;

    public static TestIO noTrace() {
        return TestIO.create(false);
    }

    public static TestIO trace() {
        return TestIO.create(true);
    }

    private static TestIO create(boolean trace) {
        return new TestIO(new InMemoryPrintStream(System.out), new InMemoryPrintStream(System.err), trace);
    }

    protected TestIO(InMemoryPrintStream stdout, InMemoryPrintStream stderr, boolean trace) {
        this.stdout = stdout;
        this.stderr = stderr;
        this.trace = trace;
    }

    public BootLogger getBootLogger() {
        return new DefaultBootLogger(this.trace, (PrintStream)this.stdout, (PrintStream)this.stderr);
    }

    public String getStderr() {
        return this.stderr.toString();
    }

    public String getStdout() {
        return this.stdout.toString();
    }
}

