/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import io.bootique.BQRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class TestRuntimesManager {
    private Collection<BQRuntime> runtimes;

    public void add(BQRuntime runtime) {
        Objects.requireNonNull(this.runtimes, "'runtimes' not initialized. Called outside factory lifecycle?");
        this.runtimes.add(runtime);
    }

    protected int size() {
        return this.runtimes != null ? this.runtimes.size() : 0;
    }

    public void reset() {
        this.runtimes = new ArrayList<BQRuntime>();
    }

    public void shutdown() {
        Collection<BQRuntime> localRuntimes = this.runtimes;
        if (localRuntimes != null) {
            localRuntimes.forEach(runtime -> {
                try {
                    runtime.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }
}

