/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.BQModuleOverrideBuilder;
import io.bootique.BQModuleProvider;
import io.bootique.BQRuntime;
import io.bootique.Bootique;
import io.bootique.command.CommandOutcome;
import io.bootique.di.Binder;
import io.bootique.junit5.TestRuntimesManager;
import io.bootique.log.BootLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TestRuntumeBuilder {
    private static final String EXCLUDE_SYSTEM_VARIABLES = "bq.core.excludeSystemVariables";
    private static final String EXCLUDE_SYSTEM_PROPERTIES = "bq.core.excludeSystemProperties";
    private Bootique bootique;
    private Map<String, String> properties = new HashMap<String, String>();
    private TestRuntimesManager runtimes;

    TestRuntumeBuilder(TestRuntimesManager runtimes, String[] args) {
        this.bootique = Bootique.app((String[])args).module(this.createPropertiesModule());
        this.runtimes = runtimes;
        this.property(EXCLUDE_SYSTEM_PROPERTIES, "true").property(EXCLUDE_SYSTEM_VARIABLES, "true");
    }

    public BQRuntime createRuntime() {
        BQRuntime runtime = this.bootique.createRuntime();
        this.runtimes.add(runtime);
        return runtime;
    }

    public CommandOutcome run() {
        return this.createRuntime().run();
    }

    protected BQModule createPropertiesModule() {
        return b -> BQCoreModule.extend((Binder)b).setProperties(this.properties);
    }

    public TestRuntumeBuilder args(String ... args) {
        this.bootique.args(args);
        return this;
    }

    public TestRuntumeBuilder args(Collection<String> args) {
        this.bootique.args(args);
        return this;
    }

    public TestRuntumeBuilder autoLoadModules() {
        this.bootique.autoLoadModules();
        return this;
    }

    public TestRuntumeBuilder bootLogger(BootLogger bootLogger) {
        this.bootique.bootLogger(bootLogger);
        return this;
    }

    public TestRuntumeBuilder module(Class<? extends BQModule> moduleType) {
        this.bootique.module(moduleType);
        return this;
    }

    @SafeVarargs
    public final TestRuntumeBuilder modules(Class<? extends BQModule> ... moduleTypes) {
        this.bootique.modules((Class[])moduleTypes);
        return this;
    }

    public TestRuntumeBuilder module(BQModule m) {
        this.bootique.module(m);
        return this;
    }

    public TestRuntumeBuilder modules(BQModule ... modules) {
        this.bootique.modules(modules);
        return this;
    }

    public TestRuntumeBuilder moduleProvider(BQModuleProvider moduleProvider) {
        this.bootique.moduleProvider(moduleProvider);
        return this;
    }

    public BQModuleOverrideBuilder<TestRuntumeBuilder> override(Class<? extends BQModule> ... overriddenTypes) {
        final BQModuleOverrideBuilder subBuilder = this.bootique.override((Class[])overriddenTypes);
        return new BQModuleOverrideBuilder<TestRuntumeBuilder>(){

            public TestRuntumeBuilder with(Class<? extends BQModule> moduleType) {
                subBuilder.with(moduleType);
                return TestRuntumeBuilder.this;
            }

            public TestRuntumeBuilder with(BQModule module) {
                subBuilder.with(module);
                return TestRuntumeBuilder.this;
            }
        };
    }

    public TestRuntumeBuilder property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }
}

