/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler;

import java.lang.reflect.Field;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.Preconditions;

public abstract class HandlerUtil {
    public static Object resolveInstance(Object testInstance, Field f) {
        Object instance;
        f.setAccessible(true);
        try {
            instance = f.get(testInstance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error reading field '" + f.getName() + "'", e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error during initialization of field '" + f.getName() + "'", e);
        }
        Preconditions.notNull((Object)instance, () -> "Test instance '" + f.getName() + "' is null. It must be initialized explicitly");
        return instance;
    }

    public static ExtensionContext getClassContext(ExtensionContext context) {
        if (context == null) {
            throw new RuntimeException("Can't find org.junit.jupiter.engine.descriptor.ClassExtensionContext in the context hierarchy");
        }
        if (context.getClass().getName().equals("org.junit.jupiter.engine.descriptor.ClassExtensionContext")) {
            return context;
        }
        return HandlerUtil.getClassContext(context.getParent().orElse(null));
    }
}

