/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.app;

import io.bootique.junit5.handler.HandlerUtil;
import io.bootique.junit5.handler.app.BQAppRegistry;
import io.bootique.junit5.handler.app.ClassAppRegistry;
import io.bootique.junit5.handler.app.GlobalAppRegistry;
import io.bootique.junit5.handler.app.MethodAppRegistry;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class BQAppHandler
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{BQAppHandler.class});
    private static final String GLOBAL_REGISTRY = "globalRegistry";
    private static final String CLASS_REGISTRY = "classRegistry";
    private static final String METHOD_REGISTRY = "methodRegistry";

    public void beforeAll(ExtensionContext context) {
        this.getOrCreateGlobalAppRegistry(context).beforeContext(context);
        this.getOrCreateClassAppRegistry(context).beforeContext(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.getOrCreateMethodAppRegistry(context).beforeContext(context);
    }

    public void afterEach(ExtensionContext context) {
        this.getOrCreateMethodAppRegistry(context).afterContext();
    }

    public void afterAll(ExtensionContext context) {
        this.getOrCreateClassAppRegistry(context).afterContext();
    }

    protected BQAppRegistry getOrCreateGlobalAppRegistry(ExtensionContext context) {
        return (BQAppRegistry)context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)GLOBAL_REGISTRY, s -> new GlobalAppRegistry());
    }

    protected BQAppRegistry getOrCreateClassAppRegistry(ExtensionContext context) {
        return (BQAppRegistry)HandlerUtil.getClassContext(context).getStore(NAMESPACE).getOrComputeIfAbsent((Object)CLASS_REGISTRY, s -> new ClassAppRegistry());
    }

    protected BQAppRegistry getOrCreateMethodAppRegistry(ExtensionContext context) {
        return (BQAppRegistry)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)METHOD_REGISTRY, s -> new MethodAppRegistry());
    }
}

