/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.app;

import io.bootique.BQRuntime;
import io.bootique.junit5.BQApp;
import io.bootique.junit5.handler.HandlerUtil;
import io.bootique.junit5.handler.app.ManagedTestRuntime;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.Preconditions;

public abstract class BQAppRegistry {
    private LinkedHashMap<Field, ManagedTestRuntime> runtimes = new LinkedHashMap();

    protected ManagedTestRuntime createManagedRuntime(Object testInstance, Field field) {
        BQRuntime runtime = (BQRuntime)HandlerUtil.resolveInstance(testInstance, field);
        Preconditions.notNull((Object)runtime, () -> "Runtime instance '" + field.getName() + "' must be initialized explicitly");
        return new ManagedTestRuntime(runtime, field.getName(), field.getAnnotation(BQApp.class));
    }

    public abstract void beforeContext(ExtensionContext var1);

    public void afterContext() {
        this.runtimes.values().stream().filter(r -> !r.immediateShutdown()).forEach(ManagedTestRuntime::shutdown);
    }

    protected void onAppFieldFound(Object testInstance, Field field) {
        this.runtimes.computeIfAbsent(field, f -> this.createManagedRuntime(testInstance, (Field)f).startIfNeeded());
    }
}

