/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.app;

import io.bootique.BQRuntime;
import io.bootique.junit5.BQApp;
import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.handler.app.BQAppRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ReflectionUtils;

public class GlobalAppRegistry
extends BQAppRegistry {
    @Override
    public void beforeContext(ExtensionContext context) {
        Class testType = context.getRequiredTestClass();
        ReflectionUtils.findFields((Class)testType, this::supportsApp, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(f -> this.onAppFieldFound(null, (Field)f));
    }

    protected boolean supportsApp(Field appField) {
        BQApp a = appField.getAnnotation(BQApp.class);
        if (a == null) {
            return false;
        }
        if (a.value() != BQTestScope.GLOBAL) {
            return false;
        }
        if (!BQRuntime.class.isAssignableFrom(appField.getType())) {
            throw new JUnitException("Field '" + appField.getDeclaringClass().getName() + "." + appField.getName() + "' is annotated with @BQApp but is not a BQRuntime.");
        }
        boolean isStatic = ReflectionUtils.isStatic((Member)appField);
        if (!isStatic) {
            throw new JUnitException("@BQApp field '" + appField.getDeclaringClass().getName() + "." + appField.getName() + "' must be static to be used in GLOBAL scope");
        }
        return true;
    }
}

