/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.app;

import io.bootique.BQRuntime;
import io.bootique.command.CommandOutcome;
import io.bootique.junit5.BQApp;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

public class ManagedTestRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedTestRuntime.class);
    private BQRuntime runtime;
    private String name;
    private BQApp config;

    public ManagedTestRuntime(BQRuntime runtime, String name, BQApp config) {
        this.runtime = runtime;
        this.name = name;
        this.config = config;
    }

    public boolean immediateShutdown() {
        return this.config.immediateShutdown();
    }

    public String getName() {
        return this.name;
    }

    public ManagedTestRuntime startIfNeeded() {
        if (!this.config.skipRun()) {
            this.run();
        }
        if (this.immediateShutdown()) {
            this.shutdown();
        }
        return this;
    }

    public void run() {
        LOGGER.debug(() -> "Starting Bootique runtime '" + this.name + "'...");
        CommandOutcome result = this.runtime.run();
        if (!result.isSuccess()) {
            Assertions.fail((String)("Runtime '" + this.getName() + " failed to start: " + result), (Throwable)result.getException());
        }
    }

    public void shutdown() {
        LOGGER.debug(() -> "Stopping Bootique runtime '" + this.name + "'...");
        try {
            this.runtime.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

