/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.testtool;

import io.bootique.junit5.handler.HandlerUtil;
import io.bootique.junit5.handler.testtool.CallbackRegistry;
import io.bootique.junit5.handler.testtool.ClassCallbackRegistry;
import io.bootique.junit5.handler.testtool.GlobalCallbackRegistry;
import io.bootique.junit5.handler.testtool.GlobalCallbacks;
import io.bootique.junit5.handler.testtool.MethodCallbackRegistry;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class BQTestToolHandler
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{BQTestToolHandler.class});
    private static final String GLOBAL_CALLBACKS = "globalCallbacks";
    private static final String GLOBAL_CALLBACK_REGISTRY = "globalCallbackRegistry";
    private static final String CLASS_CALLBACK_REGISTRY = "classCallbackRegistry";
    private static final String METHOD_CALLBACK_REGISTRY = "methodCallbackRegistry";

    public void beforeAll(ExtensionContext context) throws Exception {
        this.getOrCreateGlobalCallbackRegistry(context).beforeAll(context);
        this.getOrCreateClassCallbackRegistry(context).beforeAll(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.getOrCreateGlobalCallbackRegistry(context).beforeEach(context);
        this.getOrCreateClassCallbackRegistry(context).beforeEach(context);
        this.getOrCreateMethodCallbackRegistry(context).beforeEach(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.getOrCreateGlobalCallbackRegistry(context).afterEach(context);
        this.getOrCreateClassCallbackRegistry(context).afterEach(context);
        this.getOrCreateMethodCallbackRegistry(context).afterEach(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.getOrCreateClassCallbackRegistry(context).afterAll(context);
    }

    protected CallbackRegistry getOrCreateGlobalCallbackRegistry(ExtensionContext context) {
        ExtensionContext classContext = HandlerUtil.getClassContext(context);
        ExtensionContext rootContext = classContext.getRoot();
        GlobalCallbacks globalCallbacks = (GlobalCallbacks)rootContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)GLOBAL_CALLBACKS, s -> new GlobalCallbacks(rootContext));
        return (CallbackRegistry)classContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)GLOBAL_CALLBACK_REGISTRY, s -> GlobalCallbackRegistry.create(context, globalCallbacks));
    }

    protected CallbackRegistry getOrCreateClassCallbackRegistry(ExtensionContext context) {
        return (CallbackRegistry)HandlerUtil.getClassContext(context).getStore(NAMESPACE).getOrComputeIfAbsent((Object)CLASS_CALLBACK_REGISTRY, s -> ClassCallbackRegistry.create(context));
    }

    protected CallbackRegistry getOrCreateMethodCallbackRegistry(ExtensionContext context) {
        return (CallbackRegistry)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)METHOD_CALLBACK_REGISTRY, s -> MethodCallbackRegistry.create(context));
    }
}

