/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.testtool;

import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.handler.testtool.OnlyOnceBeforeScopeCallback;
import io.bootique.junit5.scope.BQAfterMethodCallback;
import io.bootique.junit5.scope.BQAfterScopeCallback;
import io.bootique.junit5.scope.BQBeforeMethodCallback;
import io.bootique.junit5.scope.BQBeforeScopeCallback;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;

public class Callback {
    protected BeforeAllCallback beforeAll;
    protected BeforeEachCallback beforeEach;
    protected AfterEachCallback afterEach;
    protected AfterAllCallback afterAll;

    public static Callback create(Object callback) {
        Callback callbackWrapper = new Callback();
        if (callback instanceof BQBeforeScopeCallback) {
            callbackWrapper.beforeAll = new OnlyOnceBeforeScopeCallback((BQBeforeScopeCallback)callback, BQTestScope.GLOBAL);
        }
        if (callback instanceof BQBeforeMethodCallback) {
            callbackWrapper.beforeEach = c -> ((BQBeforeMethodCallback)callback).beforeMethod(BQTestScope.GLOBAL, c);
        }
        if (callback instanceof BQAfterMethodCallback) {
            callbackWrapper.afterEach = c -> ((BQAfterMethodCallback)callback).afterMethod(BQTestScope.GLOBAL, c);
        }
        if (callback instanceof BQAfterScopeCallback) {
            callbackWrapper.afterAll = c -> ((BQAfterScopeCallback)callback).afterScope(BQTestScope.GLOBAL, c);
        }
        return callbackWrapper;
    }

    public BeforeAllCallback getBeforeAll() {
        return this.beforeAll;
    }

    public BeforeEachCallback getBeforeEach() {
        return this.beforeEach;
    }

    public AfterAllCallback getAfterAll() {
        return this.afterAll;
    }

    public AfterEachCallback getAfterEach() {
        return this.afterEach;
    }
}

