/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.testtool;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class CallbackRegistry {
    protected LinkedHashSet<BeforeAllCallback> beforeAll;
    protected LinkedHashSet<BeforeEachCallback> beforeEach;
    protected LinkedHashSet<AfterEachCallback> afterEach;
    protected LinkedHashSet<AfterAllCallback> afterAll;

    public abstract boolean supportedCallback(Field var1);

    protected <T> LinkedHashSet<T> addToCallbacks(LinkedHashSet<T> set, T instance) {
        if (set == null) {
            set = new LinkedHashSet();
        }
        set.add(instance);
        return set;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        if (this.beforeAll != null) {
            for (BeforeAllCallback c : this.beforeAll) {
                c.beforeAll(context);
            }
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.beforeEach != null) {
            for (BeforeEachCallback c : this.beforeEach) {
                c.beforeEach(context);
            }
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.afterEach != null) {
            for (AfterEachCallback c : this.afterEach) {
                c.afterEach(context);
            }
        }
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.afterAll != null) {
            for (AfterAllCallback c : this.afterAll) {
                c.afterAll(context);
            }
        }
    }
}

