/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.testtool;

import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.BQTestTool;
import io.bootique.junit5.handler.HandlerUtil;
import io.bootique.junit5.handler.testtool.CallbackRegistry;
import io.bootique.junit5.scope.BQAfterMethodCallback;
import io.bootique.junit5.scope.BQAfterScopeCallback;
import io.bootique.junit5.scope.BQBeforeMethodCallback;
import io.bootique.junit5.scope.BQBeforeScopeCallback;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ReflectionUtils;

public class ClassCallbackRegistry
extends CallbackRegistry {
    public static ClassCallbackRegistry create(ExtensionContext context) {
        ClassCallbackRegistry registry = new ClassCallbackRegistry();
        Class testType = context.getRequiredTestClass();
        Predicate<Field> predicate = f -> registry.supportedCallback((Field)f);
        ReflectionUtils.findFields((Class)testType, predicate, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(f -> registry.add(HandlerUtil.resolveInstance(null, f)));
        return registry;
    }

    @Override
    public boolean supportedCallback(Field callbackField) {
        BQTestTool a = callbackField.getAnnotation(BQTestTool.class);
        if (a == null) {
            return false;
        }
        boolean isStatic = ReflectionUtils.isStatic((Member)callbackField);
        switch (a.value()) {
            case TEST_CLASS: {
                if (!isStatic) {
                    throw new JUnitException("@BQTestTool field '" + callbackField.getDeclaringClass().getName() + "." + callbackField.getName() + "' must be static to be used in TEST_CLASS scope");
                }
                return true;
            }
            case IMPLIED: {
                return isStatic;
            }
        }
        return false;
    }

    protected void add(Object callback) {
        if (callback instanceof BQBeforeScopeCallback) {
            this.beforeAll = this.addToCallbacks(this.beforeAll, c -> ((BQBeforeScopeCallback)callback).beforeScope(BQTestScope.TEST_CLASS, c));
        }
        if (callback instanceof BQBeforeMethodCallback) {
            this.beforeEach = this.addToCallbacks(this.beforeEach, c -> ((BQBeforeMethodCallback)callback).beforeMethod(BQTestScope.TEST_CLASS, c));
        }
        if (callback instanceof BQAfterMethodCallback) {
            this.afterEach = this.addToCallbacks(this.afterEach, c -> ((BQAfterMethodCallback)callback).afterMethod(BQTestScope.TEST_CLASS, c));
        }
        if (callback instanceof BQAfterScopeCallback) {
            this.afterAll = this.addToCallbacks(this.afterAll, c -> ((BQAfterScopeCallback)callback).afterScope(BQTestScope.TEST_CLASS, c));
        }
    }
}

