/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.testtool;

import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.BQTestTool;
import io.bootique.junit5.handler.testtool.Callback;
import io.bootique.junit5.handler.testtool.CallbackRegistry;
import io.bootique.junit5.handler.testtool.GlobalCallbacks;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ReflectionUtils;

public class GlobalCallbackRegistry
extends CallbackRegistry {
    public static GlobalCallbackRegistry create(ExtensionContext context, GlobalCallbacks globalCallbacks) {
        GlobalCallbackRegistry registry = new GlobalCallbackRegistry();
        Class testType = context.getRequiredTestClass();
        Predicate<Field> predicate = f -> registry.supportedCallback((Field)f);
        ReflectionUtils.findFields((Class)testType, predicate, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(globalCallbacks::computeIfAbsent).forEach(registry::add);
        return registry;
    }

    @Override
    public boolean supportedCallback(Field callbackField) {
        BQTestTool a = callbackField.getAnnotation(BQTestTool.class);
        if (a == null) {
            return false;
        }
        if (a.value() != BQTestScope.GLOBAL) {
            return false;
        }
        if (!ReflectionUtils.isStatic((Member)callbackField)) {
            throw new JUnitException("@BQTestTool field '" + callbackField.getDeclaringClass().getName() + "." + callbackField.getName() + "' must be static to be used in GLOBAL scope");
        }
        return true;
    }

    protected void add(Callback callback) {
        if (callback.getBeforeAll() != null) {
            this.beforeAll = this.addToCallbacks(this.beforeAll, callback.getBeforeAll());
        }
        if (callback.getBeforeEach() != null) {
            this.beforeEach = this.addToCallbacks(this.beforeEach, callback.getBeforeEach());
        }
        if (callback.getAfterEach() != null) {
            this.afterEach = this.addToCallbacks(this.afterEach, callback.getAfterEach());
        }
    }
}

