/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5.handler.testtool;

import io.bootique.junit5.handler.HandlerUtil;
import io.bootique.junit5.handler.testtool.Callback;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ExtensionContext;

public class GlobalCallbacks
implements ExtensionContext.Store.CloseableResource {
    private ExtensionContext closingContext;
    private final Map<Field, Callback> callbacks = new ConcurrentHashMap<Field, Callback>();

    public GlobalCallbacks(ExtensionContext closingContext) {
        this.closingContext = Objects.requireNonNull(closingContext);
    }

    public Callback computeIfAbsent(Field f) {
        return this.computeIfAbsent(f, ff -> Callback.create(HandlerUtil.resolveInstance(null, ff)));
    }

    public Callback computeIfAbsent(Field f, Function<Field, Callback> callbackCalc) {
        return this.callbacks.computeIfAbsent(f, callbackCalc);
    }

    public void close() throws Throwable {
        for (Callback c : this.callbacks.values()) {
            if (c.getAfterAll() == null) continue;
            c.getAfterAll().afterAll(this.closingContext);
        }
    }
}

