/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne;

import io.bootique.cayenne.DataMapConfig;
import io.bootique.jdbc.DataSourceFactory;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DelegatingDataSourceFactory;

public class BQCayenneDataSourceFactory
extends DelegatingDataSourceFactory {
    private DataSourceFactory bqDataSourceFactory;
    private String defaultDataSourceName;
    private List<DataMapConfig> dataMapConfigs;

    public BQCayenneDataSourceFactory(DataSourceFactory bqDataSourceFactory, String defaultDataSourceName, List<DataMapConfig> dataMapConfigs) {
        this.bqDataSourceFactory = bqDataSourceFactory;
        this.defaultDataSourceName = defaultDataSourceName;
        this.dataMapConfigs = dataMapConfigs;
    }

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSource dataSource = this.mappedBootiqueDataSource(nodeDescriptor);
        if (dataSource != null) {
            return dataSource;
        }
        dataSource = this.cayenneDataSource(nodeDescriptor);
        if (dataSource != null) {
            return dataSource;
        }
        dataSource = this.defaultBootiqueDataSource();
        if (dataSource != null) {
            return dataSource;
        }
        return this.throwOnNoDataSource();
    }

    protected DataSource throwOnNoDataSource() {
        Collection names = this.bqDataSourceFactory.allNames();
        if (names.isEmpty()) {
            throw new IllegalStateException("No DataSources are available for Cayenne. Add a DataSource via 'bootique-jdbc' or map it in Cayenne project.");
        }
        if (this.defaultDataSourceName == null) {
            throw new IllegalStateException(String.format("Can't map Cayenne DataSource: 'cayenne.datasource' is missing. Available DataSources are %s", names));
        }
        throw new IllegalStateException(String.format("Can't map Cayenne DataSource: 'cayenne.datasource' is set to '%s'. Available DataSources: %s", this.defaultDataSourceName, names));
    }

    protected DataSource cayenneDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        if (this.shouldConfigureDataSourceFromProperties(nodeDescriptor) || nodeDescriptor.getDataSourceFactoryType() != null || nodeDescriptor.getDataSourceDescriptor() != null) {
            return super.getDataSource(nodeDescriptor);
        }
        return null;
    }

    protected DataSource defaultBootiqueDataSource() {
        Collection names = this.bqDataSourceFactory.allNames();
        if (names.size() == 1) {
            return this.mappedBootiqueDataSource((String)names.iterator().next());
        }
        return null;
    }

    protected DataSource mappedBootiqueDataSource(DataNodeDescriptor nodeDescriptor) {
        String datasource = null;
        if (!nodeDescriptor.getDataMapNames().isEmpty()) {
            String dataMapName = (String)nodeDescriptor.getDataMapNames().iterator().next();
            for (DataMapConfig dataMapConfig : this.dataMapConfigs) {
                if (!dataMapName.equals(dataMapConfig.getName())) continue;
                datasource = dataMapConfig.getDatasource();
                break;
            }
        }
        if (datasource == null) {
            datasource = this.defaultDataSourceName;
        }
        return this.mappedBootiqueDataSource(datasource);
    }

    protected DataSource mappedBootiqueDataSource(String datasource) {
        if (datasource == null) {
            return null;
        }
        DataSource ds = this.bqDataSourceFactory.forName(datasource);
        if (ds == null) {
            throw new IllegalStateException("Unknown 'defaultDataSourceName': " + datasource);
        }
        return ds;
    }
}

