/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.bootique.ConfigModule;
import io.bootique.cayenne.CayenneConfigMerger;
import io.bootique.cayenne.CayenneModuleExtender;
import io.bootique.cayenne.ServerRuntimeFactory;
import io.bootique.cayenne.annotation.CayenneConfigs;
import io.bootique.cayenne.annotation.CayenneListener;
import io.bootique.config.ConfigurationFactory;
import io.bootique.jdbc.DataSourceFactory;
import io.bootique.log.BootLogger;
import io.bootique.shutdown.ShutdownManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.Module;

public class CayenneModule
extends ConfigModule {
    public CayenneModule() {
    }

    public CayenneModule(String configPrefix) {
        super(configPrefix);
    }

    public static CayenneModuleExtender extend(com.google.inject.Binder binder) {
        return new CayenneModuleExtender(binder);
    }

    public void configure(com.google.inject.Binder binder) {
        CayenneModule.extend(binder).initAllExtensions();
    }

    @Provides
    @Singleton
    CayenneConfigMerger provideConfigMerger() {
        return new CayenneConfigMerger();
    }

    @Provides
    @Singleton
    protected ServerRuntime createCayenneRuntime(ConfigurationFactory configFactory, DataSourceFactory dataSourceFactory, BootLogger bootLogger, ShutdownManager shutdownManager, Set<Module> customModules, @CayenneListener Set<Object> listeners, Set<DataChannelFilter> filters, CayenneConfigMerger configMerger, @CayenneConfigs Set<String> injectedCayenneConfigs) {
        Collection<Module> extras = this.extraCayenneModules(customModules, filters);
        ServerRuntime runtime = ((ServerRuntimeFactory)configFactory.config(ServerRuntimeFactory.class, this.configPrefix)).createCayenneRuntime(dataSourceFactory, configMerger, extras, injectedCayenneConfigs);
        shutdownManager.addShutdownHook(() -> {
            bootLogger.trace(() -> "shutting down Cayenne...");
            runtime.shutdown();
        });
        if (!listeners.isEmpty()) {
            DataDomain domain = runtime.getDataDomain();
            listeners.forEach(arg_0 -> ((DataDomain)domain).addListener(arg_0));
        }
        return runtime;
    }

    protected Collection<Module> extraCayenneModules(Set<Module> customModules, Set<DataChannelFilter> filters) {
        ArrayList<Module> extras = new ArrayList<Module>();
        extras.addAll(customModules);
        if (!filters.isEmpty()) {
            extras.add(cayenneBinder -> {
                ListBuilder listBinder = ServerModule.contributeDomainFilters((Binder)cayenneBinder);
                filters.forEach(arg_0 -> ((ListBuilder)listBinder).add(arg_0));
            });
        }
        return extras;
    }
}

