/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import io.bootique.ModuleExtender;
import io.bootique.cayenne.annotation.CayenneConfigs;
import io.bootique.cayenne.annotation.CayenneListener;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.di.Module;

public class CayenneModuleExtender
extends ModuleExtender<CayenneModuleExtender> {
    private Multibinder<DataChannelFilter> filters;
    private Multibinder<Object> listeners;
    private Multibinder<String> projects;
    private Multibinder<Module> modules;

    public CayenneModuleExtender(Binder binder) {
        super(binder);
    }

    public CayenneModuleExtender initAllExtensions() {
        this.contributeListeners();
        this.contributeFilters();
        this.contributeModules();
        this.contributeProjects();
        return this;
    }

    public CayenneModuleExtender addFilter(DataChannelFilter filter) {
        this.contributeFilters().addBinding().toInstance((Object)filter);
        return this;
    }

    public CayenneModuleExtender addFilter(Class<? extends DataChannelFilter> filterType) {
        this.contributeFilters().addBinding().to(filterType);
        return this;
    }

    public CayenneModuleExtender addListener(Object listener) {
        this.contributeListeners().addBinding().toInstance(listener);
        return this;
    }

    public CayenneModuleExtender addListener(Class<?> listenerType) {
        this.contributeListeners().addBinding().to(listenerType);
        return this;
    }

    public CayenneModuleExtender addProject(String projectConfig) {
        this.contributeProjects().addBinding().toInstance((Object)projectConfig);
        return this;
    }

    public CayenneModuleExtender addModule(Module module) {
        this.contributeModules().addBinding().toInstance((Object)module);
        return this;
    }

    public CayenneModuleExtender addModule(Class<? extends Module> moduleType) {
        this.contributeModules().addBinding().to(moduleType);
        return this;
    }

    public CayenneModuleExtender addModule(Key<? extends Module> moduleKey) {
        this.contributeModules().addBinding().to(moduleKey);
        return this;
    }

    protected Multibinder<DataChannelFilter> contributeFilters() {
        return this.filters != null ? this.filters : (this.filters = this.newSet(DataChannelFilter.class));
    }

    protected Multibinder<Object> contributeListeners() {
        return this.listeners != null ? this.listeners : (this.listeners = this.newSet(Object.class, CayenneListener.class));
    }

    protected Multibinder<String> contributeProjects() {
        return this.projects != null ? this.projects : (this.projects = this.newSet(String.class, CayenneConfigs.class));
    }

    protected Multibinder<Module> contributeModules() {
        return this.modules != null ? this.modules : (this.modules = this.newSet(Module.class));
    }
}

