/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.cayenne.BQCayenneDataSourceFactory;
import io.bootique.cayenne.CayenneConfigMerger;
import io.bootique.cayenne.DataMapConfig;
import io.bootique.cayenne.DefaultDataSourceName;
import io.bootique.cayenne.SyntheticNodeDataDomainProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.dbsync.CreateIfNoSchemaStrategy;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategyFactory;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.server.ServerRuntimeBuilder;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Module;

@BQConfig(value="Configures Cayenne stack, providing injectable ServerRuntime.")
public class ServerRuntimeFactory {
    private static final String DEFAULT_CONFIG = "cayenne-project.xml";
    private String name;
    private Collection<String> configs = new ArrayList<String>();
    private List<DataMapConfig> maps = new ArrayList<DataMapConfig>();
    private String datasource;
    private boolean createSchema;

    public ServerRuntime createCayenneRuntime(io.bootique.jdbc.DataSourceFactory dataSourceFactory, CayenneConfigMerger configMerger, Collection<Module> extraModules, Collection<String> extraConfigs) {
        Collection<String> factoryConfigs = this.configs();
        return this.cayenneBuilder(dataSourceFactory).addConfigs(configMerger.merge(factoryConfigs, extraConfigs)).addModules(extraModules).build();
    }

    protected ServerRuntimeBuilder cayenneBuilder(io.bootique.jdbc.DataSourceFactory dataSourceFactory) {
        return ServerRuntime.builder((String)this.name).addModule(binder -> {
            if (this.createSchema) {
                binder.bind(SchemaUpdateStrategyFactory.class).toInstance(descriptor -> new CreateIfNoSchemaStrategy());
            }
            DefaultDataSourceName defaultDataSourceName = this.defaultDataSourceName(dataSourceFactory);
            binder.bind(Key.get(DefaultDataSourceName.class)).toInstance((Object)defaultDataSourceName);
            binder.bindList(DataMapConfig.class).addAll(this.maps);
            binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
            BQCayenneDataSourceFactory bqCayenneDSFactory = new BQCayenneDataSourceFactory(dataSourceFactory, this.datasource, this.maps);
            binder.bind(DataSourceFactory.class).toInstance((Object)bqCayenneDSFactory);
        });
    }

    Collection<String> configs() {
        LinkedHashSet<String> configs = new LinkedHashSet<String>();
        if (this.configs != null) {
            configs.addAll(this.configs);
        }
        return configs.isEmpty() ? this.defaultConfigs() : configs;
    }

    Collection<String> defaultConfigs() {
        if (this.maps != null && !this.maps.isEmpty()) {
            return Collections.emptySet();
        }
        return this.getClass().getClassLoader().getResource(DEFAULT_CONFIG) != null ? Collections.singleton(DEFAULT_CONFIG) : Collections.emptySet();
    }

    DefaultDataSourceName defaultDataSourceName(io.bootique.jdbc.DataSourceFactory dataSourceFactory) {
        if (this.datasource != null) {
            return new DefaultDataSourceName(this.datasource);
        }
        Collection allNames = dataSourceFactory.allNames();
        if (allNames.size() == 1) {
            return new DefaultDataSourceName((String)allNames.iterator().next());
        }
        return new DefaultDataSourceName(null);
    }

    @BQConfigProperty(value="An optional collection of Cayenne projects to load in runtime. If missing, will try to locate a file 'cayenne-project.xml' on classpath.")
    public void setConfigs(Collection<String> configs) {
        this.configs = configs;
    }

    @BQConfigProperty(value="A list of DataMaps that are included in the app runtime without an explicit refrence in 'cayenne-project.xml'.")
    public void setMaps(List<DataMapConfig> maps) {
        this.maps = maps;
    }

    @BQConfigProperty(value="An optional name of the Cayenne stack we are created. This will be the name assigned to Cayenne DataDomain and used in event dispatches, etc.")
    public void setName(String name) {
        this.name = name;
    }

    @BQConfigProperty(value="An optional name of the DataSource to use in Cayenne. A DataSource with the matching name must be defined in 'bootique-jdbc' configuration. If missing, a DataSource from Cayenne project or a default DataSource from 'bootique-jdbc' is used.")
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    @BQConfigProperty(value="Whether to attempt creation of the DB schema on startup based on Cayenne mapping. The default is 'false'. Automatic schema creation is often used in unit tests.")
    public void setCreateSchema(boolean createSchema) {
        this.createSchema = createSchema;
    }
}

