/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne;

import io.bootique.cayenne.DataMapConfig;
import io.bootique.cayenne.DefaultDataSourceName;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.XMLDataMapLoader;
import org.apache.cayenne.configuration.server.DataDomainProvider;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;

public class SyntheticNodeDataDomainProvider
extends DataDomainProvider {
    static final String DEFAULT_NAME = "cayenne";
    @Inject
    private List<DataMapConfig> dataMapConfigs;
    @Inject
    private DefaultDataSourceName defaultDatasource;

    protected DataDomain createAndInitDataDomain() throws Exception {
        DataDomain dataDomain = super.createAndInitDataDomain();
        DataNodeDescriptor defaultNodeDescriptor = this.createDefaultNodeDescriptor(dataDomain);
        Map<String, Collection<DataMapConfig>> explicitConfigs = this.getDataMapConfigs();
        if (!explicitConfigs.isEmpty()) {
            XMLDataMapLoader dataMapLoader = new XMLDataMapLoader();
            explicitConfigs.forEach((datasource, configs) -> {
                DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor(this.createSyntheticDataNodeName((String)datasource));
                ArrayList<DataChannelDescriptor> channelDescriptors = new ArrayList<DataChannelDescriptor>();
                for (DataMapConfig config : configs) {
                    URL url = config.getLocation().getUrl();
                    String dataMapName = config.getName();
                    if (dataMapName == null) {
                        dataMapName = url.toExternalForm();
                    }
                    URLResource location = new URLResource(url);
                    DataMap dataMap = dataMapLoader.load((Resource)location);
                    config.setName(dataMapName);
                    dataMap.setName(dataMapName);
                    dataDomain.addDataMap(dataMap);
                    DataChannelDescriptor channelDescriptor = new DataChannelDescriptor();
                    channelDescriptor.getDataMaps().add(dataMap);
                    channelDescriptor.getNodeDescriptors().add(nodeDescriptor);
                    channelDescriptors.add(channelDescriptor);
                    nodeDescriptor.getDataMapNames().add(dataMapName);
                }
                if (datasource.equals(this.defaultDatasource.getOptionalName()) && !defaultNodeDescriptor.getDataMapNames().isEmpty()) {
                    channelDescriptors.add(defaultNodeDescriptor.getDataChannelDescriptor());
                    nodeDescriptor.getDataMapNames().addAll(defaultNodeDescriptor.getDataMapNames());
                }
                nodeDescriptor.setDataChannelDescriptor(this.descriptorMerger.merge(channelDescriptors.toArray(new DataChannelDescriptor[channelDescriptors.size()])));
                try {
                    this.addDataNode(dataDomain, nodeDescriptor);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        } else if (dataDomain.getDataNodes().isEmpty()) {
            DataNode defaultNode = this.addDataNode(dataDomain, defaultNodeDescriptor);
            dataDomain.setDefaultNode(defaultNode);
        }
        return dataDomain;
    }

    private DataNodeDescriptor createDefaultNodeDescriptor(DataDomain dataDomain) {
        DataChannelDescriptor channelDescriptor = new DataChannelDescriptor();
        DataNodeDescriptor defaultDescriptor = new DataNodeDescriptor(this.createSyntheticDataNodeName(dataDomain));
        channelDescriptor.getNodeDescriptors().add(defaultDescriptor);
        for (DataMap map : dataDomain.getDataMaps()) {
            channelDescriptor.getDataMaps().add(map);
            defaultDescriptor.getDataMapNames().add(map.getName());
        }
        defaultDescriptor.setDataChannelDescriptor(channelDescriptor);
        return defaultDescriptor;
    }

    protected String createSyntheticDataNodeName(DataDomain domain) {
        return domain.getName() != null ? domain.getName() : DEFAULT_NAME;
    }

    protected String createSyntheticDataNodeName(String datasource) {
        return datasource + "_node";
    }

    private Map<String, Collection<DataMapConfig>> getDataMapConfigs() {
        if (this.dataMapConfigs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Collection<DataMapConfig>> result = new HashMap<String, Collection<DataMapConfig>>();
        for (DataMapConfig dataMapConfig : this.dataMapConfigs) {
            String datasource = dataMapConfig.getDatasource();
            if (datasource == null) {
                datasource = this.defaultDatasource.getOptionalName();
            }
            result.computeIfAbsent(datasource, k -> new ArrayList()).add(dataMapConfig);
        }
        return result;
    }
}

