/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.v42.junit5;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.BQRuntimeListener;
import io.bootique.cayenne.v42.CayenneModule;
import io.bootique.cayenne.v42.CayenneStartupListener;
import io.bootique.cayenne.v42.junit5.tester.CayenneRuntimeManager;
import io.bootique.cayenne.v42.junit5.tester.CayenneTesterCallbackType;
import io.bootique.cayenne.v42.junit5.tester.CayenneTesterLifecycleManager;
import io.bootique.cayenne.v42.junit5.tester.CommitCounter;
import io.bootique.cayenne.v42.junit5.tester.QueryCounter;
import io.bootique.cayenne.v42.junit5.tester.RelatedEntity;
import io.bootique.di.Binder;
import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.scope.BQAfterMethodCallback;
import io.bootique.junit5.scope.BQBeforeMethodCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.RelationshipProperty;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CayenneTester
implements BQBeforeMethodCallback,
BQAfterMethodCallback {
    private boolean refreshCayenneCaches = true;
    private boolean deleteBeforeEachTest = false;
    private boolean skipSchemaCreation = false;
    private Collection<Class<? extends Persistent>> entities;
    private Collection<Class<? extends Persistent>> entityGraphRoots;
    private boolean allTables;
    private Collection<String> tables;
    private Collection<String> tableGraphRoots;
    private Collection<RelatedEntity> relatedTables;
    private final CayenneTesterLifecycleManager lifecycleManager = new CayenneTesterLifecycleManager().callback(this::createRuntimeManager, CayenneTesterCallbackType.onCayenneStartup).callback(r -> this.createSchema(), CayenneTesterCallbackType.onCayenneStartup).callback(r -> this.refreshCaches(), CayenneTesterCallbackType.beforeTestOrOnCayenneStartupWithinTest).callback(r -> this.deleteData(), CayenneTesterCallbackType.beforeTestOrOnCayenneStartupWithinTest).callback(r -> this.commitCounter.reset(), CayenneTesterCallbackType.beforeTestOrOnCayenneStartupWithinTest).callback(r -> this.queryCounter.reset(), CayenneTesterCallbackType.beforeTestOrOnCayenneStartupWithinTest);
    private CayenneRuntimeManager runtimeManager;
    private CommitCounter commitCounter = new CommitCounter();
    private QueryCounter queryCounter = new QueryCounter();

    public static CayenneTester create() {
        return new CayenneTester();
    }

    protected CayenneTester() {
    }

    public void beforeMethod(BQTestScope scope, ExtensionContext context) {
        this.lifecycleManager.beforeMethod(scope, context);
    }

    public void afterMethod(BQTestScope scope, ExtensionContext context) {
        this.lifecycleManager.afterMethod(scope, context);
    }

    public CayenneTester onInit(Consumer<ServerRuntime> callback) {
        this.lifecycleManager.callback(callback, CayenneTesterCallbackType.onCayenneStartup);
        return this;
    }

    public CayenneTester doNoRefreshCayenneCaches() {
        this.refreshCayenneCaches = false;
        return this;
    }

    public CayenneTester skipSchemaCreation() {
        this.skipSchemaCreation = true;
        return this;
    }

    public final CayenneTester allTables() {
        this.allTables = true;
        return this;
    }

    @SafeVarargs
    public final CayenneTester entities(Class<? extends Persistent> ... entities) {
        if (this.entities == null) {
            this.entities = new HashSet<Class<? extends Persistent>>();
        }
        Collections.addAll(this.entities, entities);
        return this;
    }

    @SafeVarargs
    public final CayenneTester entitiesAndDependencies(Class<? extends Persistent> ... entities) {
        if (this.entityGraphRoots == null) {
            this.entityGraphRoots = new HashSet<Class<? extends Persistent>>();
        }
        Collections.addAll(this.entityGraphRoots, entities);
        return this;
    }

    public CayenneTester tables(String ... tables) {
        if (this.tables == null) {
            this.tables = new HashSet<String>();
        }
        Collections.addAll(this.tables, tables);
        return this;
    }

    public CayenneTester tablesAndDependencies(String ... tables) {
        if (this.tableGraphRoots == null) {
            this.tableGraphRoots = new HashSet<String>();
        }
        Collections.addAll(this.tableGraphRoots, tables);
        return this;
    }

    public CayenneTester relatedTables(Class<? extends Persistent> entityType, Property<?> relationship) {
        if (this.relatedTables == null) {
            this.relatedTables = new HashSet<RelatedEntity>();
        }
        this.relatedTables.add(new RelatedEntity(entityType, relationship.getName()));
        return this;
    }

    public CayenneTester deleteBeforeEachTest() {
        this.deleteBeforeEachTest = true;
        return this;
    }

    public BQModule moduleWithTestHooks() {
        return this::configure;
    }

    protected void configure(Binder binder) {
        BQCoreModule.extend((Binder)binder).addRuntimeListener((BQRuntimeListener)this.lifecycleManager);
        CayenneModule.extend((Binder)binder).addStartupListener((CayenneStartupListener)this.lifecycleManager).addSyncFilter((DataChannelSyncFilter)this.commitCounter).addQueryFilter((DataChannelQueryFilter)this.queryCounter);
    }

    public ServerRuntime getRuntime() {
        return this.lifecycleManager.getCayenneRuntime();
    }

    protected CayenneRuntimeManager getRuntimeManager() {
        Assertions.assertNotNull((Object)this.runtimeManager, (String)"Cayenne runtime is not resolved. Called outside of test lifecycle?");
        return this.runtimeManager;
    }

    public String getTableName(Class<? extends Persistent> entity) {
        ObjEntity e = this.getRuntime().getDataDomain().getEntityResolver().getObjEntity(entity);
        if (e == null) {
            throw new IllegalStateException("Type is not mapped in Cayenne: " + entity);
        }
        return e.getDbEntity().getName();
    }

    public String getRelatedTableName(Class<? extends Persistent> entity, RelationshipProperty<?> relationship, int tableIndex) {
        EntityResolver entityResolver = this.getRuntime().getDataDomain().getEntityResolver();
        return new RelatedEntity(entity, relationship.getName()).getRelatedTable(entityResolver, tableIndex).getName();
    }

    public void assertCommitCount(int expected) {
        this.commitCounter.assertCount(expected);
    }

    public void assertQueryCount(int expected) {
        this.queryCounter.assertCount(expected);
    }

    protected void createRuntimeManager(ServerRuntime runtime) {
        Objects.requireNonNull(runtime, "CayenneTester is not attached to a test app. To take advantage of CayenneTester, pass the module produced via 'moduleWithTestHooks' when assembling a test BQRuntime.");
        this.runtimeManager = this.allTables ? CayenneRuntimeManager.builder(runtime.getDataDomain()).dbEntities(runtime.getDataDomain().getEntityResolver().getDbEntities()).build() : CayenneRuntimeManager.builder(runtime.getDataDomain()).entities(this.entities).entityGraphRoots(this.entityGraphRoots).tables(this.tables).tableGraphRoots(this.tableGraphRoots).relatedEntities(this.relatedTables).build();
    }

    protected void createSchema() {
        if (!this.skipSchemaCreation) {
            this.getRuntimeManager().createSchema();
        }
    }

    protected void refreshCaches() {
        if (this.refreshCayenneCaches) {
            this.getRuntimeManager().refreshCaches();
        }
    }

    protected void deleteData() {
        if (this.deleteBeforeEachTest) {
            this.getRuntimeManager().deleteData();
        }
    }
}

