/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.v42.junit5.tester;

import io.bootique.cayenne.v42.junit5.tester.CayenneRuntimeManager;
import io.bootique.cayenne.v42.junit5.tester.FilteredDataMap;
import io.bootique.cayenne.v42.junit5.tester.ModelDependencyResolver;
import io.bootique.cayenne.v42.junit5.tester.RelatedEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

public class CayenneRuntimeManagerBuilder {
    private final DataDomain domain;
    private final Set<DbEntity> entities;
    private final Set<DbEntity> entityGraphs;

    protected CayenneRuntimeManagerBuilder(DataDomain domain) {
        this.domain = domain;
        this.entities = new HashSet<DbEntity>();
        this.entityGraphs = new HashSet<DbEntity>();
    }

    public CayenneRuntimeManagerBuilder dbEntities(Collection<DbEntity> entities) {
        if (entities != null) {
            this.entities.addAll(entities);
        }
        return this;
    }

    public CayenneRuntimeManagerBuilder entities(Collection<Class<? extends Persistent>> entities) {
        if (entities != null) {
            entities.forEach(e -> this.resolve(this.entities, (Class<? extends Persistent>)e));
        }
        return this;
    }

    public CayenneRuntimeManagerBuilder entityGraphRoots(Collection<Class<? extends Persistent>> entityGraphRoots) {
        if (entityGraphRoots != null) {
            entityGraphRoots.forEach(e -> this.resolveGraph(this.entityGraphs, (Class<? extends Persistent>)e));
        }
        return this;
    }

    public CayenneRuntimeManagerBuilder tables(Collection<String> tables) {
        if (tables != null) {
            tables.forEach(t -> this.resolve(this.entities, (String)t));
        }
        return this;
    }

    public CayenneRuntimeManagerBuilder tableGraphRoots(Collection<String> tableGraphRoots) {
        if (tableGraphRoots != null) {
            tableGraphRoots.forEach(t -> this.resolveGraph(this.entityGraphs, (String)t));
        }
        return this;
    }

    public CayenneRuntimeManagerBuilder relatedEntities(Collection<RelatedEntity> relatedEntities) {
        if (relatedEntities != null) {
            relatedEntities.forEach(t -> this.resolve(this.entities, (RelatedEntity)t));
        }
        return this;
    }

    public CayenneRuntimeManager build() {
        HashMap<String, LinkedHashMap> byNode = new HashMap<String, LinkedHashMap>();
        this.buildEntitiesInInsertOrder().forEach(e -> {
            DataNode node = this.domain.lookupDataNode(e.getDataMap());
            byNode.computeIfAbsent(node.getName(), nn -> new LinkedHashMap()).put(e.getName(), e);
        });
        HashMap<String, FilteredDataMap> managedEntitiesByNode = new HashMap<String, FilteredDataMap>();
        byNode.forEach((k, v) -> managedEntitiesByNode.put((String)k, new FilteredDataMap("CayenneTester_" + k, (LinkedHashMap<String, DbEntity>)v)));
        return new CayenneRuntimeManager(this.domain, managedEntitiesByNode);
    }

    private Collection<DbEntity> buildEntitiesInInsertOrder() {
        Set<Object> dbEntities;
        if (this.entities.isEmpty() && this.entityGraphs.isEmpty()) {
            dbEntities = Collections.emptySet();
        } else if (this.entities.isEmpty()) {
            dbEntities = this.entityGraphs;
        } else if (this.entityGraphs.isEmpty()) {
            dbEntities = this.entities;
        } else {
            dbEntities = new HashSet();
            dbEntities.addAll(this.entities);
            dbEntities.addAll(this.entityGraphs);
        }
        if (dbEntities.size() <= 1) {
            return dbEntities;
        }
        EntitySorter sorter = this.domain.getEntitySorter();
        ArrayList<Object> sorted = new ArrayList<Object>(dbEntities);
        sorter.sortDbEntities(sorted, false);
        return sorted;
    }

    private void resolve(Set<DbEntity> accum, String tableName) {
        accum.add(this.dbEntityForName(tableName));
    }

    private void resolveGraph(Set<DbEntity> accum, String tableName) {
        DbEntity entity = this.dbEntityForName(tableName);
        ModelDependencyResolver.resolve(accum, entity);
    }

    private void resolve(Set<DbEntity> accum, Class<? extends Persistent> type) {
        accum.add(this.dbEntityForType(type));
    }

    private void resolveGraph(Set<DbEntity> accum, Class<? extends Persistent> type) {
        DbEntity entity = this.dbEntityForType(type);
        ModelDependencyResolver.resolve(accum, entity);
    }

    private void resolve(Set<DbEntity> accum, RelatedEntity re) {
        ObjEntity e = this.domain.getEntityResolver().getObjEntity(re.getType());
        if (e == null) {
            throw new IllegalStateException("Type is not mapped in Cayenne: " + re.getType());
        }
        ObjRelationship objRelationship = e.getRelationship(re.getRelationship());
        if (objRelationship == null) {
            throw new IllegalArgumentException("No relationship '" + re.getRelationship() + "' in entity " + e.getName());
        }
        List path = objRelationship.getDbRelationships();
        if (path.size() < 2) {
            return;
        }
        path.subList(1, path.size()).stream().map(DbRelationship::getSourceEntity).forEach(accum::add);
    }

    private DbEntity dbEntityForType(Class<? extends Persistent> type) {
        ObjEntity e = this.domain.getEntityResolver().getObjEntity(type);
        if (e == null) {
            throw new IllegalStateException("Type is not mapped in Cayenne: " + type);
        }
        return e.getDbEntity();
    }

    private DbEntity dbEntityForName(String name) {
        DbEntity dbe = this.domain.getEntityResolver().getDbEntity(name);
        if (dbe == null) {
            throw new IllegalStateException("Table is not mapped in Cayenne: " + name);
        }
        return dbe;
    }
}

