/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.v42.junit5.tester;

import io.bootique.BQRuntime;
import io.bootique.BQRuntimeListener;
import io.bootique.cayenne.v42.CayenneStartupListener;
import io.bootique.cayenne.v42.junit5.tester.CayenneTesterCallbackType;
import io.bootique.di.DIRuntimeException;
import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.scope.BQAfterMethodCallback;
import io.bootique.junit5.scope.BQBeforeMethodCallback;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CayenneTesterLifecycleManager
implements BQRuntimeListener,
CayenneStartupListener,
BQBeforeMethodCallback,
BQAfterMethodCallback {
    private final Map<Consumer<ServerRuntime>, CayenneTesterCallbackType> callbacks = new LinkedHashMap<Consumer<ServerRuntime>, CayenneTesterCallbackType>();
    private BQRuntime bqRuntime;
    private ServerRuntime cayenneRuntime;
    private boolean withinTestMethod;

    public BQRuntime getBqRuntime() {
        Assertions.assertNotNull((Object)this.bqRuntime, (String)"BQRuntime is not initialized. Not connected to a Bootique runtime?");
        return this.bqRuntime;
    }

    public ServerRuntime getCayenneRuntime() {
        if (this.cayenneRuntime == null) {
            this.getBqRuntime().getInstance(ServerRuntime.class);
        }
        Assertions.assertNotNull((Object)this.cayenneRuntime, (String)"Unexpected state - ServerRuntime is not initialized");
        return this.cayenneRuntime;
    }

    public CayenneTesterLifecycleManager callback(Consumer<ServerRuntime> callback, CayenneTesterCallbackType type) {
        this.callbacks.put(callback, type);
        return this;
    }

    public void onRuntimeCreated(BQRuntime runtime) {
        this.checkUnused(runtime);
        this.bqRuntime = runtime;
    }

    public void onRuntimeCreated(ServerRuntime runtime) {
        this.cayenneRuntime = runtime;
        this.callbacks.forEach((k, v) -> this.onCayenneStarted(runtime, (Consumer<ServerRuntime>)k, (CayenneTesterCallbackType)((Object)v)));
    }

    public void beforeMethod(BQTestScope scope, ExtensionContext context) {
        this.withinTestMethod = true;
        if (this.isStarted()) {
            this.callbacks.forEach((k, v) -> this.beforeTestIfStarted(this.cayenneRuntime, (Consumer<ServerRuntime>)k, (CayenneTesterCallbackType)((Object)v)));
        }
    }

    public void afterMethod(BQTestScope scope, ExtensionContext context) {
        this.withinTestMethod = false;
    }

    private boolean isStarted() {
        return this.cayenneRuntime != null;
    }

    private void onCayenneStarted(ServerRuntime runtime, Consumer<ServerRuntime> callback, CayenneTesterCallbackType type) {
        switch (type) {
            case onCayenneStartup: {
                callback.accept(runtime);
                break;
            }
            case beforeTestOrOnCayenneStartupWithinTest: {
                if (!this.withinTestMethod) break;
                callback.accept(runtime);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void beforeTestIfStarted(ServerRuntime runtime, Consumer<ServerRuntime> callback, CayenneTesterCallbackType type) {
        if (type == CayenneTesterCallbackType.beforeTestOrOnCayenneStartupWithinTest) {
            callback.accept(runtime);
        }
    }

    private void checkUnused(BQRuntime runtime) {
        if (this.bqRuntime != null && this.bqRuntime != runtime) {
            throw new DIRuntimeException("BQRuntime is already initialized. Likely this CayenneTester is already connected to another BQRuntime. To fix this error use one CayenneTester per BQRuntime.", new Object[0]);
        }
    }
}

