/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.v42.junit5.tester;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.DataChannelSyncFilter;
import org.apache.cayenne.DataChannelSyncFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.graph.GraphDiff;
import org.junit.jupiter.api.Assertions;

public class CommitCounter
implements DataChannelSyncFilter {
    private AtomicInteger count = new AtomicInteger(0);

    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelSyncFilterChain filterChain) {
        this.count.incrementAndGet();
        return filterChain.onSync(originatingContext, changes, syncType);
    }

    public void assertCount(int expectedCommits) {
        Assertions.assertEquals((int)expectedCommits, (int)this.count.get(), (String)"Unexpected number of Cayenne commits executed");
    }

    public void reset() {
        this.count.set(0);
    }
}

