/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.cayenne.v42.junit5.tester;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cayenne.DataChannelQueryFilter;
import org.apache.cayenne.DataChannelQueryFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.query.Query;
import org.junit.jupiter.api.Assertions;

public class QueryCounter
implements DataChannelQueryFilter {
    private AtomicInteger count = new AtomicInteger(0);

    public QueryResponse onQuery(ObjectContext objectContext, Query query, DataChannelQueryFilterChain dataChannelQueryFilterChain) {
        this.count.incrementAndGet();
        return dataChannelQueryFilterChain.onQuery(objectContext, query);
    }

    public void assertCount(int expectedCommits) {
        Assertions.assertEquals((int)expectedCommits, (int)this.count.get(), (String)"Unexpected number of Cayenne queries executed");
    }

    public void reset() {
        this.count.set(0);
    }
}

