/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Binder;
import io.bootique.di.BindingBuilder;
import io.bootique.di.DecoratorBuilder;
import io.bootique.di.Key;
import io.bootique.di.MapBuilder;
import io.bootique.di.SetBuilder;
import io.bootique.di.TypeLiteral;
import io.bootique.di.spi.DefaultBindingBuilder;
import io.bootique.di.spi.DefaultDecoratorBuilder;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.DefaultMapBuilder;
import io.bootique.di.spi.DefaultSetBuilder;
import io.bootique.di.spi.OptionalBindingBuilder;
import io.bootique.di.spi.OverrideBindingBuilder;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;

class DefaultBinder
implements Binder {
    private DefaultInjector injector;

    DefaultBinder(DefaultInjector injector) {
        this.injector = injector;
    }

    @Override
    public <T> BindingBuilder<T> bind(Class<T> interfaceType) {
        return this.bind(Key.get(interfaceType));
    }

    @Override
    public <T> BindingBuilder<T> bind(Class<T> interfaceType, Class<? extends Annotation> annotationType) {
        return this.bind(Key.get(interfaceType, annotationType));
    }

    @Override
    public <T> BindingBuilder<T> bind(Class<T> interfaceType, String bindingName) {
        return this.bind(Key.get(interfaceType, bindingName));
    }

    @Override
    public <T> BindingBuilder<T> bind(Key<T> key) {
        return new DefaultBindingBuilder<T>(key, this.injector);
    }

    @Override
    public <T> BindingBuilder<T> bindOptional(Class<T> interfaceType) {
        return this.bindOptional(Key.get(interfaceType));
    }

    @Override
    public <T> BindingBuilder<T> bindOptional(Key<T> key) {
        return new OptionalBindingBuilder<T>(key, this.injector);
    }

    @Override
    public <T> BindingBuilder<T> override(Class<T> interfaceType) {
        return this.override(Key.get(interfaceType));
    }

    @Override
    public <T> BindingBuilder<T> override(Key<T> key) {
        return new OverrideBindingBuilder<T>(key, this.injector);
    }

    @Override
    public <T> SetBuilder<T> bindSet(Class<T> valueType, Class<? extends Annotation> qualifier) {
        return this.bindSet(Key.getSetOf(valueType, qualifier));
    }

    @Override
    public <T> SetBuilder<T> bindSet(Class<T> valueType, String bindingName) {
        return this.bindSet(Key.getSetOf(valueType, bindingName));
    }

    @Override
    public <T> SetBuilder<T> bindSet(Class<T> valueType) {
        return this.bindSet(Key.getSetOf(valueType));
    }

    @Override
    public <T> SetBuilder<T> bindSet(TypeLiteral<T> valueType, Class<? extends Annotation> qualifier) {
        return this.bindSet(Key.get(TypeLiteral.setOf(valueType), qualifier));
    }

    @Override
    public <T> SetBuilder<T> bindSet(TypeLiteral<T> valueType, String bindingName) {
        return this.bindSet(Key.get(TypeLiteral.setOf(valueType), bindingName));
    }

    @Override
    public <T> SetBuilder<T> bindSet(TypeLiteral<T> valueType) {
        return this.bindSet(Key.get(TypeLiteral.setOf(valueType)));
    }

    @Override
    public <K, V> MapBuilder<K, V> bindMap(Class<K> keyType, Class<V> valueType, Class<? extends Annotation> qualifier) {
        return this.bindMap(Key.getMapOf(keyType, valueType, qualifier));
    }

    @Override
    public <K, V> MapBuilder<K, V> bindMap(Class<K> keyType, Class<V> valueType, String bindingName) {
        return this.bindMap(Key.getMapOf(keyType, valueType, bindingName));
    }

    @Override
    public <K, V> MapBuilder<K, V> bindMap(Class<K> keyType, Class<V> valueType) {
        return this.bindMap(Key.getMapOf(keyType, valueType));
    }

    @Override
    public <K, V> MapBuilder<K, V> bindMap(TypeLiteral<K> keyType, TypeLiteral<V> valueType, Class<? extends Annotation> qualifier) {
        return this.bindMap(Key.getMapOf(keyType, valueType, qualifier));
    }

    @Override
    public <K, V> MapBuilder<K, V> bindMap(TypeLiteral<K> keyType, TypeLiteral<V> valueType, String bindingName) {
        return this.bindMap(Key.getMapOf(keyType, valueType, bindingName));
    }

    @Override
    public <K, V> MapBuilder<K, V> bindMap(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return this.bindMap(Key.getMapOf(keyType, valueType));
    }

    @Override
    public <T> DecoratorBuilder<T> decorate(Class<T> interfaceType) {
        return new DefaultDecoratorBuilder<T>(Key.get(interfaceType), this.injector);
    }

    @Override
    public <T> DecoratorBuilder<T> decorate(Key<T> key) {
        return new DefaultDecoratorBuilder<T>(key, this.injector);
    }

    private <T> SetBuilder<T> bindSet(Key<Set<T>> setKey) {
        return new DefaultSetBuilder<T>(setKey, this.injector);
    }

    private <K, V> MapBuilder<K, V> bindMap(Key<Map<K, V>> mapKey) {
        return new DefaultMapBuilder<K, V>(mapKey, this.injector);
    }
}

