/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.BindingBuilder;
import io.bootique.di.Key;
import io.bootique.di.Scope;
import io.bootique.di.spi.Binding;
import io.bootique.di.spi.ConstructorInjectingProvider;
import io.bootique.di.spi.CustomProvidersProvider;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.FieldInjectingProvider;
import io.bootique.di.spi.InstanceProvider;
import io.bootique.di.spi.MemberInjectingProvider;
import io.bootique.di.spi.MethodInjectingProvider;
import javax.inject.Provider;

class DefaultBindingBuilder<T>
implements BindingBuilder<T> {
    protected final DefaultInjector injector;
    protected final Key<T> bindingKey;
    protected volatile Key<? extends T> implementationKey;

    DefaultBindingBuilder(Key<T> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
        this.implementationKey = null;
        this.initBinding();
    }

    protected void initBinding() {
        this.injector.putBinding(this.bindingKey, (Provider)null);
    }

    protected void addBinding(Provider<T> provider) {
        this.injector.putBinding(this.bindingKey, provider);
    }

    @Override
    public BindingBuilder<T> to(Class<? extends T> implementation) {
        this.to((Key)Key.get(implementation));
        if (this.injector.getPredicates().isSingleton(implementation)) {
            this.inSingletonScope();
        }
        return this;
    }

    @Override
    public BindingBuilder<T> to(Key<? extends T> key) {
        if (!this.bindingKey.equals(key)) {
            this.implementationKey = key;
            this.injector.putBinding(this.implementationKey, (Provider)null);
            this.addBinding(() -> {
                this.injector.trace(() -> "Target implementation is " + this.implementationKey);
                return this.injector.getProvider(this.implementationKey).get();
            });
        }
        return this;
    }

    @Override
    public BindingBuilder<T> toInstance(T instance) {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(instance);
        MemberInjectingProvider provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        if (this.injector.isMethodInjectionEnabled()) {
            provider1 = new MethodInjectingProvider<T>(provider1, this.injector);
        }
        this.addBinding(provider1);
        return this;
    }

    @Override
    public BindingBuilder<T> toProvider(Class<? extends Provider<? extends T>> providerType) {
        Provider providerProvider = () -> {
            this.injector.trace(() -> "Resolving custom provider of type " + providerType);
            Binding binding = this.injector.getBinding(Key.get(providerType));
            if (binding != null) {
                return (Provider)binding.getScoped().get();
            }
            ConstructorInjectingProvider provider0 = new ConstructorInjectingProvider(providerType, this.injector);
            MemberInjectingProvider provider1 = new FieldInjectingProvider(provider0, this.injector);
            if (this.injector.isMethodInjectionEnabled()) {
                provider1 = new MethodInjectingProvider(provider1, this.injector);
            }
            return (Provider)provider1.get();
        };
        CustomProvidersProvider provider3 = new CustomProvidersProvider(this.injector, providerType, providerProvider);
        MemberInjectingProvider provider4 = new FieldInjectingProvider(provider3, this.injector);
        if (this.injector.isMethodInjectionEnabled()) {
            provider4 = new MethodInjectingProvider(provider4, this.injector);
        }
        this.addBinding(provider4);
        return this;
    }

    @Override
    public BindingBuilder<T> toProviderInstance(Provider<? extends T> provider) {
        InstanceProvider<Provider<? extends T>> provider0 = new InstanceProvider<Provider<? extends T>>(provider);
        MemberInjectingProvider provider1 = new FieldInjectingProvider<Provider<T>>(provider0, this.injector);
        if (this.injector.isMethodInjectionEnabled()) {
            provider1 = new MethodInjectingProvider<Provider<? extends T>>(provider1, this.injector);
        }
        Class<?> providerType = provider1.getClass();
        CustomProvidersProvider<? extends T> provider3 = new CustomProvidersProvider<T>(this.injector, providerType, provider1);
        MemberInjectingProvider provider4 = new FieldInjectingProvider<T>(provider3, this.injector);
        if (this.injector.isMethodInjectionEnabled()) {
            provider4 = new MethodInjectingProvider<T>(provider4, this.injector);
        }
        this.addBinding(provider4);
        return this;
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
        if (this.implementationKey != null) {
            this.injector.changeBindingScope(this.implementationKey, scope);
        }
    }

    @Override
    public void withoutScope() {
        this.in(this.injector.getNoScope());
    }

    @Override
    public void inSingletonScope() {
        this.in(this.injector.getSingletonScope());
    }

    @Override
    public void initOnStartup() {
        this.injector.markForEarlySetup(this.bindingKey);
        if (this.implementationKey != null) {
            this.injector.markForEarlySetup(this.implementationKey);
        }
    }
}

