/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.DecoratorBuilder;
import io.bootique.di.Key;
import io.bootique.di.spi.ConstructorInjectingDecoratorProvider;
import io.bootique.di.spi.DecoratorProvider;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.FieldInjectingDecoratorProvider;

class DefaultDecoratorBuilder<T>
implements DecoratorBuilder<T> {
    private final Key<T> bindingKey;
    private final DefaultInjector injector;

    DefaultDecoratorBuilder(Key<T> bindingKey, DefaultInjector injector) {
        this.bindingKey = bindingKey;
        this.injector = injector;
    }

    @Override
    public DecoratorBuilder<T> after(Class<? extends T> decoratorImplementationType) {
        this.injector.putDecorationAfter(this.bindingKey, this.decoratorProvider(decoratorImplementationType));
        return this;
    }

    @Override
    public DecoratorBuilder<T> before(Class<? extends T> decoratorImplementationType) {
        this.injector.putDecorationBefore(this.bindingKey, this.decoratorProvider(decoratorImplementationType));
        return this;
    }

    private DecoratorProvider<T> decoratorProvider(Class<? extends T> decoratorType) {
        ConstructorInjectingDecoratorProvider<? extends T> provider0 = new ConstructorInjectingDecoratorProvider<T>(decoratorType, this.injector);
        FieldInjectingDecoratorProvider<? extends T> provider1 = new FieldInjectingDecoratorProvider<T>(decoratorType, provider0, this.injector);
        return provider1;
    }
}

