/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.BQModule;
import io.bootique.di.DIRuntimeException;
import io.bootique.di.InjectionTraceElement;
import io.bootique.di.Injector;
import io.bootique.di.Key;
import io.bootique.di.Scope;
import io.bootique.di.spi.Binding;
import io.bootique.di.spi.ConstructorInjectingProvider;
import io.bootique.di.spi.Decoration;
import io.bootique.di.spi.DecoratorProvider;
import io.bootique.di.spi.DefaultBinder;
import io.bootique.di.spi.DefaultScope;
import io.bootique.di.spi.FieldInjectingProvider;
import io.bootique.di.spi.InjectionStack;
import io.bootique.di.spi.InjectionTrace;
import io.bootique.di.spi.InjectorPredicates;
import io.bootique.di.spi.InstanceProvider;
import io.bootique.di.spi.MemberInjectingProvider;
import io.bootique.di.spi.MethodInjectingProvider;
import io.bootique.di.spi.NoScope;
import io.bootique.di.spi.ProvidesHandler;
import io.bootique.di.spi.ProxyInvocationHandler;
import io.bootique.di.spi.TraceableProvider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Provider;

public class DefaultInjector
implements Injector {
    private final DefaultScope singletonScope;
    private final Scope noScope;
    private final DefaultBinder binder;
    private final Map<Key<?>, Binding<?>> bindings;
    private final Map<Key<?>, Decoration<?>> decorations;
    private final ProvidesHandler providesHandler;
    private final InjectionStack injectionStack;
    private final InjectionTrace injectionTrace;
    private final Scope defaultScope;
    private final InjectorPredicates predicates;
    private final Set<Key<?>> earlySetupSet;
    private final Map<Class<?>, List<Key<?>>> keysByRawType;
    private final boolean allowDynamicBinding;
    private final boolean allowOverride;
    private final boolean allowMethodInjection;
    private final boolean injectionTraceEnabled;
    private final boolean allowProxyCreation;
    private volatile boolean isShutdown;

    DefaultInjector(BQModule ... modules) {
        this(Collections.emptySet(), new InjectorPredicates(), modules);
    }

    public DefaultInjector(Set<Options> options, InjectorPredicates predicates, BQModule ... modules) {
        this.predicates = predicates;
        this.singletonScope = new DefaultScope(new Class[0]);
        this.noScope = NoScope.INSTANCE;
        this.defaultScope = options.contains((Object)Options.SINGLETON_SCOPE_BY_DEFAULT) ? this.singletonScope : this.noScope;
        this.allowOverride = !options.contains((Object)Options.DECLARED_OVERRIDE_ONLY);
        this.allowDynamicBinding = !options.contains((Object)Options.DISABLE_DYNAMIC_BINDINGS);
        this.allowMethodInjection = options.contains((Object)Options.ENABLE_METHOD_INJECTION);
        this.injectionTraceEnabled = !options.contains((Object)Options.DISABLE_TRACE);
        this.allowProxyCreation = !options.contains((Object)Options.DISABLE_PROXY);
        this.bindings = new ConcurrentHashMap();
        this.decorations = new ConcurrentHashMap();
        this.injectionStack = new InjectionStack();
        this.injectionTrace = this.injectionTraceEnabled ? new InjectionTrace() : null;
        this.providesHandler = new ProvidesHandler(this);
        this.binder = new DefaultBinder(this);
        this.earlySetupSet = Collections.newSetFromMap(new ConcurrentHashMap());
        this.keysByRawType = new ConcurrentHashMap();
        this.binder.bind(Injector.class).toInstance(this);
        if (modules != null && modules.length > 0) {
            for (BQModule module : modules) {
                module.configure(this.binder);
                this.providesHandler.bindingsFromAnnotatedMethods(module);
            }
        }
        this.applyDecorators();
        this.earlySetup();
    }

    InjectionStack getInjectionStack() {
        return this.injectionStack;
    }

    DefaultBinder getBinder() {
        return this.binder;
    }

    ProvidesHandler getProvidesHandler() {
        return this.providesHandler;
    }

    InjectorPredicates getPredicates() {
        return this.predicates;
    }

    <T> Binding<T> getBinding(Key<T> key) {
        if (this.isShutdown) {
            this.throwException("Injector is shutdown", new Object[0]);
        }
        return this.bindings.get(Objects.requireNonNull(key, "Null key"));
    }

    <T> void putBinding(Key<T> bindingKey, Provider<T> provider) {
        this.putBinding(bindingKey, new Binding<T>(bindingKey, this.wrapProvider(bindingKey, provider), this.defaultScope, false));
    }

    <T> void putOptionalBinding(Key<T> bindingKey, Provider<T> provider) {
        this.putBinding(bindingKey, new Binding<T>(bindingKey, this.wrapProvider(bindingKey, provider), this.defaultScope, true));
    }

    <T> void overrideBinding(Key<T> bindingKey, Provider<T> provider) {
        Binding<T> binding;
        Binding<T> oldBinding;
        if (this.isShutdown) {
            this.throwException("Injector is shutdown", new Object[0]);
        }
        if ((oldBinding = this.bindings.put(bindingKey, binding = new Binding<T>(bindingKey, this.wrapProvider(bindingKey, provider), this.defaultScope, false))) == null) {
            this.throwException("No binding to override for key %s", bindingKey);
        }
    }

    <T> void putBinding(Key<T> bindingKey, Binding<T> binding) {
        Binding<T> oldBinding;
        if (this.isShutdown) {
            this.throwException("Injector is shutdown", new Object[0]);
        }
        if ((oldBinding = this.bindings.put(bindingKey, binding)) == null) {
            this.keysByRawType.computeIfAbsent(bindingKey.getType().getRawType(), type -> new ArrayList(1)).add(bindingKey);
        }
        if (!this.canOverride(oldBinding)) {
            this.throwException("Unable to override key %s. It is final and override is disabled.", bindingKey);
        }
    }

    private boolean canOverride(Binding<?> oldBinding) {
        return oldBinding == null || oldBinding.getOriginal() == null || oldBinding.isOptional() || this.allowOverride;
    }

    private <T> Decoration<T> getDecoration(Key<T> bindingKey) {
        if (this.isShutdown) {
            this.throwException("Injector is shutdown", new Object[0]);
        }
        return this.decorations.computeIfAbsent(bindingKey, bk -> new Decoration());
    }

    <T> void putDecorationAfter(Key<T> bindingKey, DecoratorProvider<T> decoratorProvider) {
        this.getDecoration(bindingKey).after(decoratorProvider);
    }

    <T> void putDecorationBefore(Key<T> bindingKey, DecoratorProvider<T> decoratorProvider) {
        this.getDecoration(bindingKey).before(decoratorProvider);
    }

    <T> void changeBindingScope(Key<T> bindingKey, Scope scope) {
        Binding<?> binding;
        if (scope == null) {
            scope = this.noScope;
        }
        if ((binding = this.bindings.get(bindingKey)) == null) {
            this.throwException("No existing binding for key " + bindingKey, new Object[0]);
            return;
        }
        binding.changeScope(scope);
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getInstanceWithCycleProtection(Key.get(type));
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getInstanceWithCycleProtection(key);
    }

    <T> T getInstanceWithCycleProtection(Key<T> key) {
        return this.getInstanceWithCycleProtection(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getInstanceWithCycleProtection(Key<T> key, boolean fromProxy) {
        if (!this.injectionStack.push(key)) {
            T proxy;
            if (this.allowProxyCreation && !fromProxy && (proxy = this.getProxyInstance(key)) != null) {
                return proxy;
            }
            this.throwException("Circular dependency detected when binding a key %s. Nested keys: %s. To resolve it, you should inject a Provider instead of an object.", key, this.injectionStack);
        }
        try {
            Object object = this.getProvider(key).get();
            return (T)object;
        }
        finally {
            this.injectionStack.pop();
        }
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    private <T> T getProxyInstance(Key<T> key) {
        Class<T> bindingClass = key.getType().getRawType();
        if (!bindingClass.isInterface()) {
            return null;
        }
        ProxyInvocationHandler<T> handler = new ProxyInvocationHandler<T>(this, key);
        Object proxyInstance = Proxy.newProxyInstance(bindingClass.getClassLoader(), new Class[]{bindingClass}, handler);
        this.trace(() -> "Create proxy for binding " + key);
        return (T)proxyInstance;
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Binding<T> binding = this.getBinding(key);
        if (binding == null || binding.getOriginal() == null) {
            binding = this.createDynamicBinding(key);
        }
        return this.predicates.wrapProvider(binding.getScoped());
    }

    @Override
    public boolean hasProvider(Class<?> type) {
        return this.hasProvider(Key.get(type));
    }

    @Override
    public boolean hasProvider(Key<?> key) {
        return this.getBinding(key) != null;
    }

    private <T> Binding<T> createDynamicBinding(Key<T> key) {
        return this.bindings.compute(key, (k, oldBinding) -> {
            if (oldBinding == null && !this.allowDynamicBinding) {
                this.throwException("DI container has no binding for key %s and dynamic bindings are disabled.", key);
            }
            if (oldBinding != null && oldBinding.getOriginal() != null) {
                return oldBinding;
            }
            Class implementation = key.getType().getRawType();
            ConstructorInjectingProvider provider = new ConstructorInjectingProvider(implementation, this);
            Scope scope = this.defaultScope;
            if (oldBinding != null && oldBinding.getScope() != this.defaultScope) {
                scope = oldBinding.getScope();
            } else if (this.getPredicates().isSingleton(implementation)) {
                scope = this.singletonScope;
            }
            return new Binding(key, this.wrapInMemberInjectionProviders(key, provider), scope, false);
        });
    }

    private <T> Provider<T> wrapInMemberInjectionProviders(Key<T> key, Provider<T> provider) {
        MemberInjectingProvider provider1 = new FieldInjectingProvider<T>(provider, this);
        if (this.isMethodInjectionEnabled()) {
            provider1 = new MethodInjectingProvider<T>(provider1, this);
        }
        return this.wrapProvider(key, provider1);
    }

    @Override
    public void injectMembers(Object object) {
        Key<?> key = Key.get(object.getClass());
        this.wrapInMemberInjectionProviders(key, new InstanceProvider<Object>(object)).get();
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.singletonScope.shutdown();
        this.bindings.clear();
        this.decorations.clear();
        this.injectionStack.reset();
        this.keysByRawType.clear();
    }

    @Override
    public <T> Collection<Key<T>> getKeysByType(Class<T> type) {
        return this.keysByRawType.getOrDefault(type, Collections.emptyList());
    }

    DefaultScope getSingletonScope() {
        return this.singletonScope;
    }

    Scope getDefaultScope() {
        return this.defaultScope;
    }

    Scope getNoScope() {
        return this.noScope;
    }

    boolean isMethodInjectionEnabled() {
        return this.allowMethodInjection;
    }

    boolean isInjectionTraceEnabled() {
        return this.injectionTraceEnabled;
    }

    Map<Key<?>, Binding<?>> getAllBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    private void applyDecorators() {
        for (Map.Entry<Key<?>, Decoration<?>> e : this.decorations.entrySet()) {
            Binding<?> b = this.bindings.get(e.getKey());
            if (b == null) continue;
            b.decorate(this, e.getValue());
        }
    }

    void markForEarlySetup(Key<?> key) {
        this.changeBindingScope(key, this.getSingletonScope());
        this.earlySetupSet.add(key);
    }

    private void earlySetup() {
        this.earlySetupSet.forEach(this::getInstance);
        this.earlySetupSet.clear();
    }

    <T> Provider<T> wrapProvider(Key<T> key, Provider<T> provider) {
        if (!this.injectionTraceEnabled || provider == null) {
            return provider;
        }
        return new TraceableProvider<T>(key, provider, this);
    }

    void trace(Supplier<String> messageSupplier) {
        if (this.injectionTraceEnabled) {
            this.injectionTrace.updateMessage(messageSupplier);
        }
    }

    void tracePush(Key<?> key) {
        if (this.injectionTraceEnabled) {
            this.injectionTrace.push(key);
        }
    }

    void tracePop() {
        if (this.injectionTraceEnabled) {
            this.injectionTrace.pop();
        }
    }

    <T> T throwException(String message, Object ... args) throws DIRuntimeException {
        throw this.setTrace(this.predicates.createException(message, args));
    }

    <T> T throwException(String message, Throwable cause, Object ... args) throws DIRuntimeException {
        if (cause instanceof InvocationTargetException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof DIRuntimeException) {
            throw (DIRuntimeException)cause;
        }
        throw this.setTrace(this.predicates.createException(message, cause, args));
    }

    private DIRuntimeException setTrace(DIRuntimeException ex) {
        InjectionTraceElement element;
        if (!this.injectionTraceEnabled) {
            return ex;
        }
        InjectionTraceElement[] traceElements = new InjectionTraceElement[this.injectionTrace.size()];
        int i = 0;
        while ((element = this.injectionTrace.pop()) != null) {
            traceElements[i++] = element;
        }
        ex.setInjectionTrace(traceElements);
        return ex;
    }

    public static enum Options {
        SINGLETON_SCOPE_BY_DEFAULT,
        DECLARED_OVERRIDE_ONLY,
        DISABLE_DYNAMIC_BINDINGS,
        ENABLE_METHOD_INJECTION,
        DISABLE_TRACE,
        DISABLE_PROXY;

    }
}

