/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.DIRuntimeException;
import io.bootique.di.Key;
import io.bootique.di.MapBuilder;
import io.bootique.di.spi.Binding;
import io.bootique.di.spi.DICollectionBuilder;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.MapProvider;
import io.bootique.di.spi.TraceableProvider;
import java.util.Map;
import javax.inject.Provider;

class DefaultMapBuilder<K, V>
extends DICollectionBuilder<Map<K, V>, V>
implements MapBuilder<K, V> {
    DefaultMapBuilder(Key<Map<K, V>> bindingKey, DefaultInjector injector) {
        super(bindingKey, injector);
        this.findOrCreateMapProvider();
    }

    @Override
    public MapBuilder<K, V> put(K key, Class<? extends V> interfaceType) {
        Provider<? extends V> provider = this.getByTypeProvider(interfaceType);
        this.findOrCreateMapProvider().put(key, provider);
        return this;
    }

    @Override
    public MapBuilder<K, V> putInstance(K key, V value) {
        this.findOrCreateMapProvider().put(key, this.createInstanceProvider(value));
        return this;
    }

    @Override
    public MapBuilder<K, V> put(K key, Key<? extends V> valueKey) {
        this.findOrCreateMapProvider().put(key, this.getByKeyProvider(valueKey));
        return this;
    }

    @Override
    public MapBuilder<K, V> putProviderInstance(K key, Provider<? extends V> value) throws DIRuntimeException {
        this.findOrCreateMapProvider().put(key, value);
        return this;
    }

    @Override
    public MapBuilder<K, V> putProvider(K key, Class<? extends Provider<? extends V>> value) throws DIRuntimeException {
        this.findOrCreateMapProvider().put(key, this.createProviderProvider(value));
        return this;
    }

    @Override
    public MapBuilder<K, V> putInstances(Map<K, V> map) {
        MapProvider<K, V> provider = this.findOrCreateMapProvider();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            provider.put(entry.getKey(), this.createInstanceProvider(entry.getValue()));
        }
        return this;
    }

    private MapProvider<K, V> findOrCreateMapProvider() {
        MapProvider provider;
        Binding binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new MapProvider(this.injector);
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = this.injector.isInjectionTraceEnabled() ? (MapProvider)((TraceableProvider)binding.getOriginal()).unwrap() : (MapProvider)binding.getOriginal();
        }
        return provider;
    }
}

