/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.BeforeScopeEnd;
import io.bootique.di.Scope;
import io.bootique.di.spi.AfterScopeEnd;
import io.bootique.di.spi.DefaultScopeProvider;
import io.bootique.di.spi.ScopeEventBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Provider;

public class DefaultScope
implements Scope {
    private static final String SPECIAL_EVENT = AfterScopeEnd.class.getName();
    protected final Collection<Class<? extends Annotation>> eventTypes;
    protected final Map<String, Collection<ScopeEventBinding>> listeners = new ConcurrentHashMap<String, Collection<ScopeEventBinding>>();

    @SafeVarargs
    public DefaultScope(Class<? extends Annotation> ... customEventTypes) {
        this.eventTypes = Collections.newSetFromMap(new ConcurrentHashMap());
        this.eventTypes.add(BeforeScopeEnd.class);
        this.eventTypes.add(AfterScopeEnd.class);
        if (customEventTypes != null) {
            Collections.addAll(this.eventTypes, customEventTypes);
        }
        for (Class<? extends Annotation> type : this.eventTypes) {
            this.listeners.put(type.getName(), new ConcurrentLinkedQueue());
        }
    }

    public void shutdown() {
        this.postScopeEvent(BeforeScopeEnd.class, new Object[0]);
        this.postScopeEvent(AfterScopeEnd.class, new Object[0]);
    }

    public void addScopeEventListener(Object object) {
        for (Method method : object.getClass().getMethods()) {
            for (Class<? extends Annotation> annotationType : this.eventTypes) {
                if (!method.isAnnotationPresent(annotationType)) continue;
                String typeName = annotationType.getName();
                Collection<ScopeEventBinding> eventListeners = this.listeners.get(typeName);
                eventListeners.add(new ScopeEventBinding(object, method));
            }
        }
    }

    public void removeScopeEventListener(Object object) {
        for (Map.Entry<String, Collection<ScopeEventBinding>> entry : this.listeners.entrySet()) {
            if (SPECIAL_EVENT.equals(entry.getKey())) continue;
            entry.getValue().removeIf(binding -> binding.getObject() == object);
        }
    }

    public void postScopeEvent(Class<? extends Annotation> type, Object ... eventParameters) {
        Collection<ScopeEventBinding> eventListeners = this.listeners.get(type.getName());
        if (eventListeners != null) {
            eventListeners.removeIf(listener -> !listener.onScopeEvent(eventParameters));
        }
    }

    @Override
    public <T> Provider<T> scope(Provider<T> unscoped) {
        return new DefaultScopeProvider<T>(this, unscoped);
    }
}

