/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import java.util.LinkedList;
import java.util.List;

class InjectionStack {
    private final ThreadLocal<LinkedList<Key<?>>> stack = new ThreadLocal();

    InjectionStack() {
    }

    void reset() {
        List localStack = this.stack.get();
        if (localStack != null) {
            localStack.clear();
        }
    }

    boolean push(Key<?> bindingKey) {
        LinkedList<Key<Object>> localStack = this.stack.get();
        if (localStack == null) {
            localStack = new LinkedList();
            this.stack.set(localStack);
        }
        if (localStack.contains(bindingKey)) {
            return false;
        }
        localStack.add(bindingKey);
        return true;
    }

    void pop() {
        LinkedList<Key<?>> localStack = this.stack.get();
        if (localStack == null) {
            throw new IndexOutOfBoundsException("0");
        }
        localStack.removeLast();
    }

    public String toString() {
        List localStack = this.stack.get();
        if (localStack != null) {
            return String.valueOf(localStack);
        }
        return "[]";
    }
}

