/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.InjectionTraceElement;
import io.bootique.di.Key;
import java.util.LinkedList;
import java.util.function.Supplier;

class InjectionTrace {
    private ThreadLocal<LinkedList<InjectionTraceElement>> stack = new ThreadLocal();

    InjectionTrace() {
    }

    void push(Key<?> key) {
        this.getStack().push(new InjectionTraceElement(key));
    }

    void updateMessage(Supplier<String> messageSupplier) {
        InjectionTraceElement element = this.getStack().peekFirst();
        if (element != null) {
            element.setMessage(messageSupplier);
        }
    }

    InjectionTraceElement pop() {
        return this.getStack().pollFirst();
    }

    int size() {
        return this.getStack().size();
    }

    private LinkedList<InjectionTraceElement> getStack() {
        LinkedList<InjectionTraceElement> localStack = this.stack.get();
        if (localStack == null) {
            localStack = new LinkedList();
            this.stack.set(localStack);
        }
        return localStack;
    }
}

