/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.spi.DIUtil;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.NamedProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import javax.inject.Provider;

abstract class MemberInjectingProvider<T>
implements NamedProvider<T> {
    protected final DefaultInjector injector;
    protected final Provider<T> delegate;

    MemberInjectingProvider(Provider<T> delegate, DefaultInjector injector) {
        this.delegate = delegate;
        this.injector = injector;
    }

    public T get() {
        Object result;
        try {
            result = this.delegate.get();
        }
        catch (Exception ex) {
            return this.injector.throwException("Underlying provider (%s) thrown exception", ex, DIUtil.getProviderName(this.delegate));
        }
        if (result == null) {
            return this.injector.throwException("Underlying provider (%s) returned NULL instance", DIUtil.getProviderName(this.delegate));
        }
        this.injectMembers(result, result.getClass());
        return (T)result;
    }

    abstract void injectMembers(T var1, Class<?> var2);

    Annotation getQualifier(Annotation[] annotations, AccessibleObject object) {
        Annotation bindingAnnotation = null;
        for (Annotation fieldAnnotation : annotations) {
            if (!this.injector.getPredicates().isQualifierAnnotation(fieldAnnotation)) continue;
            if (bindingAnnotation != null) {
                this.injector.throwException("Found more than one qualifier annotation for '%s.%s'.", ((Member)((Object)object)).getDeclaringClass().getName(), ((Member)((Object)object)).getName());
            }
            bindingAnnotation = fieldAnnotation;
        }
        return bindingAnnotation;
    }

    Annotation getQualifier(AccessibleObject object) {
        return this.getQualifier(object.getAnnotations(), object);
    }
}

