/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.TypeLiteral;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.GenericTypesUtils;
import io.bootique.di.spi.InjectionStack;
import io.bootique.di.spi.MemberInjectingProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;

class MethodInjectingProvider<T>
extends MemberInjectingProvider<T> {
    private static final int PRIVATE = 0;
    private static final int PACKAGE = 1;
    private static final int PROTECTED = 2;
    private static final int PUBLIC = 3;

    MethodInjectingProvider(Provider<T> delegate, DefaultInjector injector) {
        super(delegate, injector);
    }

    @Override
    protected void injectMembers(T object, Class<?> type) {
        Map<String, List<Method>> methods = MethodInjectingProvider.collectMethods(type, new LinkedHashMap<String, List<Method>>());
        for (List<Method> methodList : methods.values()) {
            methodList.forEach(method -> {
                if (this.injector.getPredicates().hasInjectAnnotation((AccessibleObject)method)) {
                    this.injectMember(object, (Method)method);
                }
            });
        }
    }

    static Map<String, List<Method>> collectMethods(Class<?> type, Map<String, List<Method>> seenMethods) {
        if (type == Object.class) {
            return seenMethods;
        }
        MethodInjectingProvider.collectMethods(type.getSuperclass(), seenMethods);
        for (Method method : type.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            String methodSignature = MethodInjectingProvider.getMethodSignature(method);
            List parentMethods = seenMethods.computeIfAbsent(methodSignature, sig -> new ArrayList());
            parentMethods.removeIf(parentMethod -> MethodInjectingProvider.isMethodOverride(parentMethod, method));
            parentMethods.add(method);
        }
        return seenMethods;
    }

    private static boolean isMethodOverride(Method parentMethod, Method method) {
        int parentModifier = MethodInjectingProvider.modifiersToInt(parentMethod.getModifiers());
        if (parentModifier == 0) {
            return false;
        }
        if (parentModifier == 1) {
            return method.getDeclaringClass().getPackage().equals(parentMethod.getDeclaringClass().getPackage());
        }
        return true;
    }

    private static int modifiersToInt(int methodModifiers) {
        if (Modifier.isPrivate(methodModifiers) || Modifier.isStatic(methodModifiers)) {
            return 0;
        }
        if (Modifier.isProtected(methodModifiers)) {
            return 2;
        }
        if (Modifier.isPublic(methodModifiers)) {
            return 3;
        }
        return 1;
    }

    static String getMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append(' ').append(method.getName()).append('(');
        for (Type type : method.getGenericParameterTypes()) {
            sb.append(type.getTypeName()).append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    private void injectMember(Object object, Method method) {
        Object[] values = this.arguments(method);
        this.injector.trace(() -> "Injecting method '" + method.getName() + "()' of class " + method.getDeclaringClass().getName());
        method.setAccessible(true);
        try {
            method.invoke(object, values);
        }
        catch (Exception e) {
            this.injector.throwException("Error injecting into method '%s()' of class '%s'", e, method.getName(), method.getDeclaringClass().getName());
        }
    }

    private Object[] arguments(Method method) {
        Type[] parameterTypes = method.getGenericParameterTypes();
        Class<?>[] parameterClasses = method.getParameterTypes();
        Object[] result = new Object[parameterTypes.length];
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        InjectionStack stack = this.injector.getInjectionStack();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            Annotation bindingAnnotation = this.getQualifier(parameterAnnotations[i], method);
            int idx = i;
            this.injector.trace(() -> "Get argument " + idx + " for method '" + method.getName() + "()' of class '" + method.getDeclaringClass().getName() + "'");
            if (this.injector.getPredicates().isProviderType(parameterClasses[i])) {
                if ((parameterType = GenericTypesUtils.getGenericParameterType(parameterType)) == null) {
                    this.injector.throwException("Parameter of method '%s.%s()' of 'Provider' type must be parameterized to be usable for injection", method.getDeclaringClass().getName(), method.getName());
                }
                result[i] = this.injector.getProvider(Key.get(TypeLiteral.of(parameterType), bindingAnnotation));
                continue;
            }
            Key key = Key.get(TypeLiteral.of(parameterType), bindingAnnotation);
            result[i] = this.injector.getInstanceWithCycleProtection(key);
        }
        return result;
    }

    @Override
    public String getName() {
        return "method injecting provider";
    }
}

