/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.spi.Binding;
import io.bootique.di.spi.DefaultBindingBuilder;
import io.bootique.di.spi.DefaultInjector;
import java.util.Optional;
import javax.inject.Provider;

class OptionalBindingBuilder<T>
extends DefaultBindingBuilder<T> {
    static final Provider<?> NULL_PROVIDER = () -> null;

    OptionalBindingBuilder(Key<T> bindingKey, DefaultInjector injector) {
        super(bindingKey, injector);
    }

    @Override
    protected void initBinding() {
        Binding binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            this.injector.putOptionalBinding(this.bindingKey, OptionalBindingBuilder.nullProvider());
        }
        this.injector.putBinding(Key.getOptionalOf(this.bindingKey), () -> {
            Object value = this.injector.getProvider(this.bindingKey).get();
            return value == null ? Optional.empty() : Optional.of(value);
        });
    }

    private static <T> Provider<T> nullProvider() {
        return NULL_PROVIDER;
    }
}

