/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.Scope;
import io.bootique.di.TypeLiteral;
import io.bootique.di.spi.Binding;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.NamedProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import javax.inject.Provider;

class ProvidesHandler {
    private final DefaultInjector injector;

    ProvidesHandler(DefaultInjector injector) {
        this.injector = injector;
    }

    void bindingsFromAnnotatedMethods(Object module) {
        Predicate<Method> providesMethodPredicate = this.injector.getPredicates().getProvidesMethodPredicate();
        for (Method m : module.getClass().getDeclaredMethods()) {
            if (!providesMethodPredicate.test(m)) continue;
            this.validateProvidesMethod(module, m);
            m.setAccessible(true);
            this.createBinding(module, m);
        }
    }

    private void validateProvidesMethod(Object module, Method method) {
        if (Void.TYPE.equals(method.getReturnType())) {
            this.injector.throwException("Provider method '%s()' on module '%s' is void. To be a proper provider method, it must return a value", method.getName(), module.getClass().getName());
        }
    }

    private <T> void createBinding(Object module, Method method) {
        Key<T> key = this.createKey(method.getGenericReturnType(), this.extractQualifier(method, method.getDeclaredAnnotations()));
        Binding<T> binding = this.createBinding(key, module, method);
        this.injector.putBinding(key, binding);
    }

    private Annotation extractQualifier(Method method, Annotation[] annotations) {
        Annotation found = null;
        Predicate<Class<? extends Annotation>> qualifierPredicate = this.injector.getPredicates().getQualifierPredicate();
        for (Annotation a : annotations) {
            if (!qualifierPredicate.test(a.annotationType())) continue;
            if (found != null) {
                this.injector.throwException("Multiple qualifying annotations found for method '%s()' or its parameter on module '%s'", method.getName(), method.getDeclaringClass().getName());
            }
            found = a;
        }
        return found;
    }

    private <T> Key<T> createKey(Type bindingType, Annotation qualifier) {
        if (this.isProviderType(bindingType)) {
            bindingType = ((ParameterizedType)bindingType).getActualTypeArguments()[0];
        }
        return Key.get(TypeLiteral.of(bindingType), qualifier);
    }

    private boolean isProviderType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.injector.getPredicates().isProviderType(parameterizedType.getRawType());
        }
        return false;
    }

    private <T> Binding<T> createBinding(Key<T> key, Object module, Method method) {
        return new Binding<T>(key, this.createProvider(key, module, method), this.createScope(method), false);
    }

    private <T> Provider<T> createProvider(Key<T> key, Object module, Method method) {
        Provider<?>[] argumentProviders = this.createArgumentProviders(method);
        ProvidesMethodProvider provider = new ProvidesMethodProvider(this.injector, argumentProviders, method, module);
        return this.injector.wrapProvider(key, provider);
    }

    private Scope createScope(Method method) {
        if (this.injector.getPredicates().isSingleton(method)) {
            return this.injector.getSingletonScope();
        }
        return this.injector.getDefaultScope();
    }

    private Provider<?>[] createArgumentProviders(Method method) {
        Type[] params = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        int len = params.length;
        Provider[] providers = new Provider[len];
        for (int i = 0; i < len; ++i) {
            Annotation qualifier = this.extractQualifier(method, paramAnnotations[i]);
            Key key = this.createKey(params[i], qualifier);
            providers[i] = this.isProviderType(params[i]) ? () -> this.injector.getProvider(key) : () -> this.injector.getInstance(key);
        }
        return providers;
    }

    private static class ProvidesMethodProvider<T>
    implements NamedProvider<T> {
        private final DefaultInjector injector;
        private final Provider<?>[] argumentProviders;
        private final Method method;
        private final Object module;

        private ProvidesMethodProvider(DefaultInjector injector, Provider<?>[] argumentProviders, Method method, Object module) {
            this.injector = injector;
            this.argumentProviders = argumentProviders;
            this.method = method;
            this.module = module;
        }

        public T get() {
            int len = this.argumentProviders.length;
            Object[] arguments = new Object[len];
            for (int i = 0; i < len; ++i) {
                int idx = i;
                this.injector.trace(() -> "Get argument " + idx + " for " + this.getName());
                arguments[i] = this.argumentProviders[i].get();
            }
            this.injector.trace(() -> "Invoking " + this.getName());
            try {
                Object result = this.method.invoke(this.module, arguments);
                return (T)result;
            }
            catch (Exception e) {
                this.injector.throwException("Error invoking %s", e, this.getName());
                return null;
            }
        }

        @Override
        public String getName() {
            return String.format("provider method '%s()' of module '%s'", this.method.getName(), this.module.getClass().getName());
        }
    }
}

