/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.spi.DefaultInjector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class ProxyInvocationHandler<T>
implements InvocationHandler {
    private final DefaultInjector injector;
    private final Key<T> key;
    private volatile T instance;

    ProxyInvocationHandler(DefaultInjector injector, Key<T> key) {
        this.injector = injector;
        this.key = key;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object ... args) throws Throwable {
        method.setAccessible(true);
        return method.invoke(this.getInstance(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getInstance() {
        T local = this.instance;
        if (local == null) {
            Key<T> key = this.key;
            synchronized (key) {
                local = this.instance;
                if (local == null) {
                    local = this.instance = this.injector.getInstanceWithCycleProtection(this.key, true);
                }
            }
        }
        return local;
    }
}

