/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.di.spi;

import io.bootique.di.Key;
import io.bootique.di.spi.DIUtil;
import io.bootique.di.spi.DefaultInjector;
import io.bootique.di.spi.OptionalBindingBuilder;
import java.util.Objects;
import javax.inject.Provider;

class TraceableProvider<T>
implements Provider<T> {
    private final Key<T> key;
    private final Provider<T> delegate;
    private final DefaultInjector injector;

    TraceableProvider(Key<T> key, Provider<T> delegate, DefaultInjector injector) {
        this.key = Objects.requireNonNull(key);
        this.delegate = Objects.requireNonNull(delegate);
        this.injector = Objects.requireNonNull(injector);
    }

    public T get() {
        Object result;
        this.injector.tracePush(this.key);
        try {
            result = this.delegate.get();
        }
        catch (Exception ex) {
            return this.injector.throwException("Underlying provider (%s) thrown exception", ex, DIUtil.getProviderName(this.delegate));
        }
        if (result == null && this.delegate != OptionalBindingBuilder.NULL_PROVIDER) {
            this.injector.throwException("Underlying provider (%s) returned NULL instance", DIUtil.getProviderName(this.delegate));
        }
        this.injector.tracePop();
        return (T)result;
    }

    <P extends Provider<T>> P unwrap() {
        return (P)this.delegate;
    }

    public Key<T> getKey() {
        return this.key;
    }
}

