/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc.tomcat;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.inject.Injector;
import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.jdbc.managed.ManagedDataSourceFactory;
import io.bootique.jdbc.managed.ManagedDataSourceStarter;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.ObjectName;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

@BQConfig(value="Pooling Tomcat JDBC DataSource configuration.")
@JsonTypeName(value="tomcat")
public class TomcatManagedDataSourceFactory
implements ManagedDataSourceFactory {
    private int abandonWhenPercentageFull = 0;
    private boolean alternateUsernameAllowed = false;
    private boolean commitOnReturn = false;
    private String dataSourceJNDI;
    private Boolean defaultAutoCommit;
    private String defaultCatalog;
    private Boolean defaultReadOnly;
    private String defaultTransactionIsolation;
    private String driverClassName;
    private boolean fairQueue = true;
    private boolean ignoreExceptionOnPreLoad = false;
    private int initialSize = 10;
    private String initSQL;
    private String jdbcInterceptors;
    private boolean jmxEnabled = false;
    private String jmxObjectName;
    private boolean logAbandoned = false;
    private boolean logValidationErrors = false;
    private int maxActive = 100;
    private long maxAge = 0L;
    private int maxIdle = 100;
    private int maxWait = 30000;
    private int minEvictableIdleTimeMillis = 60000;
    private int minIdle = 10;
    private int numTestsPerEvictionRun = 0;
    private String password;
    private boolean propagateInterruptState = false;
    private boolean removeAbandoned = false;
    private int removeAbandonedTimeout = 60;
    private boolean rollbackOnReturn = false;
    private int suspectTimeout = 0;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    private boolean testOnConnect = false;
    private int timeBetweenEvictionRunsMillis = 5000;
    private String url;
    private String username;
    private boolean useDisposableConnectionFacade = true;
    private boolean useEquals = true;
    private boolean useLock = false;
    private String validationQuery;
    private int validationQueryTimeout = -1;
    private String validatorClassName;
    private long validationInterval = 30000L;

    public ManagedDataSourceStarter create(String dataSourceName, Injector injector) {
        Supplier<javax.sql.DataSource> startup = () -> {
            this.validate();
            PoolConfiguration poolConfig = this.toConfiguration();
            DataSource dataSource = new DataSource(poolConfig);
            try {
                dataSource.createPool();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating DataSource", e);
            }
            return dataSource;
        };
        Consumer<javax.sql.DataSource> shutdown = ds -> ((DataSource)ds).close();
        return new ManagedDataSourceStarter(this.getUrl(), startup, shutdown);
    }

    protected void validate() {
        Objects.requireNonNull(this.url, "'url' property should not be null");
    }

    @BQConfigProperty
    public void setAbandonWhenPercentageFull(int abandonWhenPercentageFull) {
        this.abandonWhenPercentageFull = abandonWhenPercentageFull;
    }

    @BQConfigProperty
    public void setAlternateUsernameAllowed(boolean alternateUsernameAllowed) {
        this.alternateUsernameAllowed = alternateUsernameAllowed;
    }

    @BQConfigProperty
    public void setCommitOnReturn(boolean commitOnReturn) {
        this.commitOnReturn = commitOnReturn;
    }

    @BQConfigProperty
    public void setDataSourceJNDI(String dataSourceJNDI) {
        this.dataSourceJNDI = dataSourceJNDI;
    }

    @BQConfigProperty
    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @BQConfigProperty
    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    @BQConfigProperty
    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @BQConfigProperty
    public void setDefaultTransactionIsolation(String defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    @BQConfigProperty
    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @BQConfigProperty
    public void setFairQueue(boolean fairQueue) {
        this.fairQueue = fairQueue;
    }

    @BQConfigProperty
    public void setIgnoreExceptionOnPreLoad(boolean ignoreExceptionOnPreLoad) {
        this.ignoreExceptionOnPreLoad = ignoreExceptionOnPreLoad;
    }

    @BQConfigProperty
    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    @BQConfigProperty
    public void setInitSQL(String initSQL) {
        this.initSQL = initSQL;
    }

    @BQConfigProperty
    public void setJdbcInterceptors(String jdbcInterceptors) {
        this.jdbcInterceptors = jdbcInterceptors;
    }

    @BQConfigProperty
    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    @BQConfigProperty
    public void setJmxObjectName(String jmxObjectName) {
        this.jmxObjectName = jmxObjectName;
    }

    @BQConfigProperty
    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    @BQConfigProperty
    public void setLogValidationErrors(boolean logValidationErrors) {
        this.logValidationErrors = logValidationErrors;
    }

    @BQConfigProperty
    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    @BQConfigProperty
    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    @BQConfigProperty
    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    @BQConfigProperty
    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    @BQConfigProperty
    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    @BQConfigProperty
    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    @BQConfigProperty
    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    @BQConfigProperty
    public void setPassword(String password) {
        this.password = password;
    }

    @BQConfigProperty
    public void setPropagateInterruptState(boolean propagateInterruptState) {
        this.propagateInterruptState = propagateInterruptState;
    }

    @BQConfigProperty
    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    @BQConfigProperty
    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    @BQConfigProperty
    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    @BQConfigProperty
    public void setSuspectTimeout(int suspectTimeout) {
        this.suspectTimeout = suspectTimeout;
    }

    @BQConfigProperty
    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    @BQConfigProperty
    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    @BQConfigProperty
    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    @BQConfigProperty
    public void setTestOnConnect(boolean testOnConnect) {
        this.testOnConnect = testOnConnect;
    }

    @BQConfigProperty
    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    @BQConfigProperty
    public void setUsername(String username) {
        this.username = username;
    }

    @BQConfigProperty
    public void setUseDisposableConnectionFacade(boolean useDisposableConnectionFacade) {
        this.useDisposableConnectionFacade = useDisposableConnectionFacade;
    }

    @BQConfigProperty
    public void setUseEquals(boolean useEquals) {
        this.useEquals = useEquals;
    }

    @BQConfigProperty
    public void setUseLock(boolean useLock) {
        this.useLock = useLock;
    }

    @BQConfigProperty
    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    @BQConfigProperty
    public void setValidationQueryTimeout(int validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    @BQConfigProperty
    public void setValidatorClassName(String validatorClassName) {
        this.validatorClassName = validatorClassName;
    }

    @BQConfigProperty
    public void setValidationInterval(long validationInterval) {
        this.validationInterval = validationInterval;
    }

    public String getUrl() {
        return this.url;
    }

    @BQConfigProperty
    public void setUrl(String url) {
        this.url = url;
    }

    protected PoolConfiguration toConfiguration() {
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setDefaultAutoCommit(this.defaultAutoCommit);
        poolProperties.setDefaultReadOnly(this.defaultReadOnly);
        poolProperties.setDefaultTransactionIsolation(this.getTransactionIsolationLevelInt());
        poolProperties.setDefaultCatalog(this.defaultCatalog);
        poolProperties.setDriverClassName(this.driverClassName);
        poolProperties.setMaxActive(this.maxActive);
        poolProperties.setMaxIdle(this.maxIdle);
        poolProperties.setMinIdle(this.minIdle);
        poolProperties.setInitialSize(this.initialSize);
        poolProperties.setMaxWait(this.maxWait);
        poolProperties.setTestOnBorrow(this.testOnBorrow);
        poolProperties.setTestOnReturn(this.testOnReturn);
        poolProperties.setTestOnConnect(this.testOnConnect);
        poolProperties.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        poolProperties.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        poolProperties.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        poolProperties.setTestWhileIdle(this.testWhileIdle);
        poolProperties.setPassword(this.password);
        poolProperties.setUrl(this.url);
        poolProperties.setUsername(this.username);
        poolProperties.setValidationQuery(this.validationQuery);
        poolProperties.setValidationQueryTimeout(this.validationQueryTimeout);
        poolProperties.setValidatorClassName(this.validatorClassName);
        poolProperties.setValidationInterval(this.validationInterval);
        poolProperties.setRemoveAbandoned(this.removeAbandoned);
        poolProperties.setRemoveAbandonedTimeout(this.removeAbandonedTimeout);
        poolProperties.setLogAbandoned(this.logAbandoned);
        poolProperties.setDbProperties(new Properties());
        if (poolProperties.getUsername() != null) {
            poolProperties.getDbProperties().setProperty("user", poolProperties.getUsername());
        }
        if (poolProperties.getPassword() != null) {
            poolProperties.getDbProperties().setProperty("password", poolProperties.getPassword());
        }
        poolProperties.setInitSQL(this.initSQL);
        poolProperties.setJdbcInterceptors(this.jdbcInterceptors);
        poolProperties.setJmxEnabled(this.jmxEnabled);
        poolProperties.setFairQueue(this.fairQueue);
        poolProperties.setUseEquals(this.useEquals);
        if (this.jmxObjectName != null) {
            poolProperties.setName(ObjectName.quote(this.jmxObjectName));
        }
        poolProperties.setAbandonWhenPercentageFull(this.abandonWhenPercentageFull);
        poolProperties.setMaxAge(this.maxAge);
        poolProperties.setUseLock(this.useLock);
        poolProperties.setDataSourceJNDI(this.dataSourceJNDI);
        poolProperties.setSuspectTimeout(this.suspectTimeout);
        poolProperties.setAlternateUsernameAllowed(this.alternateUsernameAllowed);
        poolProperties.setCommitOnReturn(this.commitOnReturn);
        poolProperties.setRollbackOnReturn(this.rollbackOnReturn);
        poolProperties.setUseDisposableConnectionFacade(this.useDisposableConnectionFacade);
        poolProperties.setLogValidationErrors(this.logValidationErrors);
        poolProperties.setPropagateInterruptState(this.propagateInterruptState);
        poolProperties.setIgnoreExceptionOnPreLoad(this.ignoreExceptionOnPreLoad);
        return poolProperties;
    }

    protected int getTransactionIsolationLevelInt() {
        if (this.defaultTransactionIsolation == null) {
            return -1;
        }
        if ("NONE".equalsIgnoreCase(this.defaultTransactionIsolation)) {
            return 0;
        }
        if ("READ_COMMITTED".equalsIgnoreCase(this.defaultTransactionIsolation)) {
            return 2;
        }
        if ("READ_UNCOMMITTED".equalsIgnoreCase(this.defaultTransactionIsolation)) {
            return 1;
        }
        if ("REPEATABLE_READ".equalsIgnoreCase(this.defaultTransactionIsolation)) {
            return 4;
        }
        if ("SERIALIZABLE".equalsIgnoreCase(this.defaultTransactionIsolation)) {
            return 8;
        }
        try {
            return Integer.parseInt(this.defaultTransactionIsolation);
        }
        catch (NumberFormatException nfex) {
            throw new IllegalStateException("Unrecognized 'defaultTransactionIsolation': " + this.defaultTransactionIsolation);
        }
    }
}

