/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc;

import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;

public final class DataSourceUnwrapper {
    public static <T extends DataSource> Optional<T> unwrap(DataSource dataSource, Class<T> desiredType) {
        try {
            return dataSource.isWrapperFor(desiredType) ? Optional.of((DataSource)dataSource.unwrap(desiredType)) : Optional.empty();
        }
        catch (SQLException e) {
            throw new RuntimeException("Exception trying to unwrap " + desiredType.getName(), e);
        }
    }

    private DataSourceUnwrapper() {
    }
}

