/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.ModuleCrate;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Provides;
import io.bootique.jdbc.DataSourceFactory;
import io.bootique.jdbc.DataSourceListener;
import io.bootique.jdbc.JdbcFactory;
import io.bootique.jdbc.JdbcModuleExtender;
import io.bootique.jdbc.LazyDataSourceFactory;
import io.bootique.jdbc.ManagedDataSourceTypeDetector;
import io.bootique.jdbc.managed.ManagedDataSourceStarter;
import io.bootique.log.BootLogger;
import io.bootique.shutdown.ShutdownManager;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;

public class JdbcModule
implements BQModule {
    static final String CONFIG_PREFIX = "jdbc";

    public static JdbcModuleExtender extend(Binder binder) {
        return new JdbcModuleExtender(binder);
    }

    public ModuleCrate crate() {
        return ModuleCrate.of((BQModule)this).description("Configures and exposes named JDBC DataSources").config(CONFIG_PREFIX, JdbcFactory.class).build();
    }

    public void configure(Binder binder) {
        JdbcModule.extend(binder).initAllExtensions();
        BQCoreModule.extend((Binder)binder).addConfigLoader(ManagedDataSourceTypeDetector.class);
    }

    @Singleton
    @Provides
    DataSourceFactory createDataSource(Map<String, ManagedDataSourceStarter> starters, BootLogger bootLogger, ShutdownManager shutdownManager, Set<DataSourceListener> listeners) {
        return (DataSourceFactory)shutdownManager.onShutdown((Object)new LazyDataSourceFactory(starters, listeners), LazyDataSourceFactory::shutdown);
    }

    @Singleton
    @Provides
    Map<String, ManagedDataSourceStarter> provideDataSourceStarters(ConfigurationFactory configFactory) {
        return ((JdbcFactory)configFactory.config(JdbcFactory.class, CONFIG_PREFIX)).create();
    }
}

