/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ConnectionBuilder;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.ShardingKeyBuilder;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class LazyDataSource
implements DataSource,
AutoCloseable {
    private final Supplier<DataSource> supplier;
    private volatile DataSource delegate;

    public LazyDataSource(Supplier<DataSource> supplier) {
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource getDelegate() {
        if (this.delegate == null) {
            LazyDataSource lazyDataSource = this;
            synchronized (lazyDataSource) {
                if (this.delegate == null) {
                    this.delegate = Objects.requireNonNull(this.supplier.get());
                }
            }
        }
        return this.delegate;
    }

    @Override
    public void close() throws Exception {
        DataSource local = this.delegate;
        if (local instanceof AutoCloseable) {
            ((AutoCloseable)((Object)local)).close();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDelegate().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDelegate().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDelegate().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDelegate().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDelegate().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDelegate().getLoginTimeout();
    }

    @Override
    public ConnectionBuilder createConnectionBuilder() throws SQLException {
        return this.getDelegate().createConnectionBuilder();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.getDelegate().getParentLogger();
    }

    @Override
    public ShardingKeyBuilder createShardingKeyBuilder() throws SQLException {
        return this.getDelegate().createShardingKeyBuilder();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)(iface.isInstance(this) ? this : this.getDelegate().unwrap(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) ? true : this.getDelegate().isWrapperFor(iface);
    }
}

