/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc;

import io.bootique.jdbc.DataSourceFactory;
import io.bootique.jdbc.DataSourceListener;
import io.bootique.jdbc.managed.ManagedDataSource;
import io.bootique.jdbc.managed.ManagedDataSourceStarter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;

public class LazyDataSourceFactory
implements DataSourceFactory {
    private Collection<DataSourceListener> listeners;
    private Map<String, ManagedDataSourceStarter> starters;
    private ConcurrentMap<String, ManagedDataSource> dataSources = new ConcurrentHashMap<String, ManagedDataSource>();

    public LazyDataSourceFactory(Map<String, ManagedDataSourceStarter> starters, Set<DataSourceListener> listeners) {
        this.starters = starters;
        this.listeners = listeners;
    }

    public void shutdown() {
        this.dataSources.values().forEach(ManagedDataSource::shutdown);
        this.dataSources.forEach((name, dataSource) -> this.listeners.forEach(listener -> listener.afterShutdown((String)name, dataSource.getUrl(), dataSource.getDataSource())));
    }

    @Override
    public Collection<String> allNames() {
        return this.starters.keySet();
    }

    @Override
    public DataSource forName(String dataSourceName) {
        ManagedDataSource managedDataSource = this.dataSources.computeIfAbsent(dataSourceName, this::createManagedDataSource);
        return managedDataSource.getDataSource();
    }

    @Override
    public boolean isStarted(String dataSourceName) {
        return this.dataSources.containsKey(dataSourceName);
    }

    protected ManagedDataSource createManagedDataSource(String name) {
        ManagedDataSourceStarter starter = this.starters.get(name);
        if (starter == null) {
            throw new IllegalStateException("No configuration present for DataSource named '" + name + "'");
        }
        if (this.listeners.isEmpty()) {
            return starter.start();
        }
        String url = starter.getUrl();
        this.listeners.forEach(listener -> listener.beforeStartup(name, url));
        ManagedDataSource dataSource = starter.start();
        this.listeners.forEach(listener -> listener.afterStartup(name, url, dataSource.getDataSource()));
        return dataSource;
    }
}

