/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jdbc;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.bootique.BootiqueException;
import io.bootique.config.jackson.JsonConfigurationLoader;
import io.bootique.di.Injector;
import io.bootique.di.Key;
import io.bootique.di.TypeLiteral;
import io.bootique.jdbc.managed.ManagedDataSourceFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

class ManagedDataSourceTypeDetector
implements JsonConfigurationLoader {
    private static final String TYPE_FIELD = "type";
    public static int ORDER = 1030;
    private final Injector injector;

    @Inject
    public ManagedDataSourceTypeDetector(Injector injector) {
        this.injector = injector;
    }

    public int getOrder() {
        return ORDER;
    }

    public JsonNode updateConfiguration(JsonNode mutableInput) {
        JsonNode dataSources = mutableInput.get("jdbc");
        if (dataSources == null || !dataSources.isObject() || dataSources.isEmpty()) {
            return mutableInput;
        }
        ArrayList<ObjectNode> noTypes = new ArrayList<ObjectNode>(dataSources.size());
        for (JsonNode ds : dataSources) {
            if (!ds.isObject() || ds.get(TYPE_FIELD) != null) continue;
            noTypes.add((ObjectNode)ds);
        }
        if (noTypes.isEmpty()) {
            return mutableInput;
        }
        String type = this.defaultJsonTypeName();
        for (ObjectNode ds : noTypes) {
            ds.put(TYPE_FIELD, type);
        }
        return mutableInput;
    }

    private String defaultJsonTypeName() {
        Key setKey = Key.get((TypeLiteral)new TypeLiteral<Set<Class<? extends ManagedDataSourceFactory>>>(){});
        Set allFactories = (Set)this.injector.getProvider(setKey).get();
        Set<Class<? extends ManagedDataSourceFactory>> types = ManagedDataSourceTypeDetector.leafFactories(allFactories);
        switch (types.size()) {
            case 0: {
                throw new BootiqueException(1, "No concrete 'bootique-jdbc' implementation found. You will need to add one (such as 'bootique-jdbc-hikaricp', etc.) as an application dependency.");
            }
            case 1: {
                return ManagedDataSourceTypeDetector.jsonTypeName(types.iterator().next());
            }
        }
        List typeNames = types.stream().map(t -> ManagedDataSourceTypeDetector.jsonTypeName(t)).collect(Collectors.toList());
        throw new BootiqueException(1, "More than one 'bootique-jdbc' implementation is found. There's no single default. As a result, each DataSource configuration must provide an explicit 'type' property. Supported types: " + typeNames);
    }

    static String jsonTypeName(Class<?> type) {
        JsonTypeName typeName = type.getAnnotation(JsonTypeName.class);
        if (typeName == null) {
            throw new BootiqueException(1, "Invalid ManagedDataSourceFactory:  " + type.getName() + ". Not annotated with @JsonTypeName.");
        }
        return typeName.value();
    }

    static Set<Class<? extends ManagedDataSourceFactory>> leafFactories(Set<Class<? extends ManagedDataSourceFactory>> allFactories) {
        HashSet<Class<? extends ManagedDataSourceFactory>> leafFactories = new HashSet<Class<? extends ManagedDataSourceFactory>>(allFactories);
        for (Class<? extends ManagedDataSourceFactory> factory : allFactories) {
            leafFactories.remove(factory.getSuperclass());
        }
        return leafFactories;
    }
}

