/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jersey;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.RuntimeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="3.0", forRemoval=true)
public class ResourceModelDebugger
implements ModelProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceModelDebugger.class);

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        if (LOGGER.isDebugEnabled()) {
            ArrayList resources = new ArrayList();
            resourceModel.getRuntimeResourceModel().getRuntimeResources().forEach(r -> this.appendReported(resources, (RuntimeResource)r));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("The following HTTP resources are available:");
                resources.stream().sorted().forEach(this::traceResource);
            } else {
                LOGGER.debug("The following HTTP resources are available:");
                resources.stream().sorted().forEach(this::debugResource);
            }
        }
        return resourceModel;
    }

    private void traceResource(ReportedResource resource) {
        resource.methods.stream().sorted().forEach(rm -> LOGGER.trace("    {} {} {}", new Object[]{rm.method, resource.path, rm.handler.getName()}));
    }

    private void debugResource(ReportedResource resource) {
        resource.methods.stream().filter(rm -> !rm.handler.getName().startsWith("org.glassfish.jersey.server.wadl")).sorted().forEach(rm -> LOGGER.debug("    {} {}", (Object)rm.method, (Object)resource.path));
    }

    private void appendReported(List<ReportedResource> appendTo, RuntimeResource rt) {
        if (!rt.getResourceMethods().isEmpty()) {
            this.toReported(rt).forEach(appendTo::add);
        }
        rt.getChildRuntimeResources().forEach(r -> this.appendReported(appendTo, (RuntimeResource)r));
    }

    private List<ReportedResource> toReported(RuntimeResource rt) {
        return rt.getResources().stream().map(this::toReported).collect(Collectors.toList());
    }

    private ReportedResource toReported(Resource r) {
        String path = this.appendPath(new StringBuilder(), r).toString();
        List<ReportedResourceMethod> methods = r.getResourceMethods().stream().map(rm -> new ReportedResourceMethod(rm.getHttpMethod(), rm.getInvocable().getHandler().getHandlerClass())).collect(Collectors.toList());
        return new ReportedResource(path, methods);
    }

    private StringBuilder appendPath(StringBuilder path, Resource r) {
        String p;
        if (r.getParent() != null) {
            this.appendPath(path, r.getParent());
        }
        if (!(p = r.getPath()).startsWith("/")) {
            path.append("/");
        }
        path.append(p);
        return path;
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        return subResourceModel;
    }

    static class ReportedResourceMethod
    implements Comparable<ReportedResourceMethod> {
        final String method;
        final Class<?> handler;

        ReportedResourceMethod(String method, Class<?> handler) {
            this.method = method;
            this.handler = handler;
        }

        @Override
        public int compareTo(ReportedResourceMethod o) {
            return this.method.compareTo(o.method);
        }
    }

    static class ReportedResource
    implements Comparable<ReportedResource> {
        final String path;
        final List<ReportedResourceMethod> methods;

        ReportedResource(String path, List<ReportedResourceMethod> methods) {
            this.path = path;
            this.methods = methods;
        }

        @Override
        public int compareTo(ReportedResource o) {
            return this.path.compareTo(o.path);
        }
    }
}

