/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty;

import io.bootique.BQCoreModule;
import io.bootique.BQModule;
import io.bootique.ModuleCrate;
import io.bootique.config.ConfigurationFactory;
import io.bootique.di.Binder;
import io.bootique.di.Provides;
import io.bootique.jetty.JettyModuleExtender;
import io.bootique.jetty.command.ServerCommand;
import io.bootique.jetty.request.RequestMDCItem;
import io.bootique.jetty.request.RequestMDCManager;
import io.bootique.jetty.server.ServerFactory;
import io.bootique.jetty.server.ServerHolder;
import io.bootique.jetty.servlet.DefaultServletEnvironment;
import io.bootique.jetty.servlet.ServletEnvironment;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Singleton;
import org.eclipse.jetty.server.Server;

public class JettyModule
implements BQModule {
    private static final String CONFIG_PREFIX = "jetty";

    public static JettyModuleExtender extend(Binder binder) {
        return new JettyModuleExtender(binder);
    }

    public ModuleCrate crate() {
        return ModuleCrate.of((BQModule)this).description("Integrates Jetty web server").config(CONFIG_PREFIX, ServerFactory.class).build();
    }

    public void configure(Binder binder) {
        BQCoreModule.extend((Binder)binder).addCommand(ServerCommand.class).setLogLevel("org.eclipse.jetty", Level.INFO);
        JettyModule.extend(binder).initAllExtensions().addListener(DefaultServletEnvironment.class);
    }

    @Singleton
    @Provides
    ServletEnvironment createStateTracker(DefaultServletEnvironment stateImpl) {
        return stateImpl;
    }

    @Singleton
    @Provides
    DefaultServletEnvironment createStateTrackerImpl() {
        return new DefaultServletEnvironment();
    }

    @Singleton
    @Provides
    Server providerServer(ServerHolder holder) {
        return holder.getServer();
    }

    @Singleton
    @Provides
    ServerHolder provideServerHolder(ServerFactory factory) {
        return factory.createServerHolder();
    }

    @Provides
    @Singleton
    RequestMDCManager provideRequestMDCManager(Map<String, RequestMDCItem> items) {
        return new RequestMDCManager(items);
    }

    @Singleton
    @Provides
    ServerFactory providerServerFactory(ConfigurationFactory configFactory) {
        return (ServerFactory)configFactory.config(ServerFactory.class, CONFIG_PREFIX);
    }
}

