/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.request;

import io.bootique.jetty.request.RequestMDCItem;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;

public class RequestMDCManager
implements HttpChannel.Listener {
    private final Map<String, RequestMDCItem> items;

    public RequestMDCManager(Map<String, RequestMDCItem> items) {
        this.items = Objects.requireNonNull(items);
    }

    public void onRequestBegin(Request request) {
        this.items.values().forEach(e -> e.initMDC((ServletContext)request.getContext(), (ServletRequest)request));
    }

    public void onComplete(Request request) {
        this.items.values().forEach(e -> e.cleanupMDC((ServletContext)request.getContext(), (ServletRequest)request));
    }

    public Set<String> mdcKeys() {
        return this.items.keySet();
    }
}

