/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.jetty.server.ConnectorHolder;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Server;

public class ServerHolder {
    private Server server;
    private String context;
    private Collection<ConnectorHolder> connectors;

    public ServerHolder(Server server, String context, Collection<ConnectorHolder> connectors) {
        this.server = server;
        this.context = context;
        this.connectors = connectors;
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public Server getServer() {
        return this.server;
    }

    public String getContext() {
        return this.context;
    }

    public int getConnectorsCount() {
        return this.connectors.size();
    }

    public String getUrl() {
        return this.getConnector().getUrl(this.context);
    }

    public ConnectorHolder getConnector() {
        if (this.getConnectorsCount() != 1) {
            throw new IllegalStateException("'getConnector' can be called when there is one and only one connector. Instead there are " + this.getConnectorsCount() + " connectors");
        }
        return this.connectors.iterator().next();
    }

    public Stream<ConnectorHolder> getConnectors() {
        return this.connectors.stream();
    }

    public Stream<String> getUrls() {
        return this.getConnectors().map(cd -> cd.getUrl(this.context));
    }
}

