/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.servlet;

import io.bootique.jetty.servlet.StaticServlet;
import io.bootique.resource.FolderResourceFactory;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBaseStaticServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiBaseStaticServlet.class);
    private DoGetProcessor doGetProcessor;
    private List<StaticServlet> delegates;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.delegates = this.createDelegates();
        this.doGetProcessor = this.delegates.size() == 1 ? new DoGetOne(this.delegates.get(0)) : new DoGetMany(this.delegates.toArray(new StaticServlet[0]));
        for (HttpServlet httpServlet : this.delegates) {
            httpServlet.init(config);
        }
    }

    public void destroy() {
        for (HttpServlet httpServlet : this.delegates) {
            httpServlet.destroy();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGetProcessor.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    protected List<StaticServlet> createDelegates() {
        String resourceBase = this.getInitParameter("resourceBase");
        if (resourceBase == null) {
            return Collections.singletonList(new StaticServlet(null));
        }
        Collection<URL> resourceBaseUrls = this.resolveFolderResourceFactory(resourceBase);
        if (resourceBaseUrls.isEmpty()) {
            return Collections.singletonList(new StaticServlet(null));
        }
        ArrayList<StaticServlet> delegates = new ArrayList<StaticServlet>(resourceBaseUrls.size());
        for (URL baseUrl : resourceBaseUrls) {
            delegates.add(new StaticServlet(baseUrl.toExternalForm()));
        }
        if (delegates.size() > 1) {
            LOGGER.info("Found multiple base URLs for resource base '{}': {}", (Object)resourceBase, resourceBaseUrls);
        }
        return delegates;
    }

    protected Collection<URL> resolveFolderResourceFactory(String path) {
        try {
            return new FolderResourceFactory(path).getUrls();
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Static servlet base directory '{}' does not exist", (Object)path);
            return Collections.emptyList();
        }
    }

    static class DoGetMany
    implements DoGetProcessor {
        private StaticServlet[] delegates;

        public DoGetMany(StaticServlet[] delegates) {
            this.delegates = delegates;
        }

        @Override
        public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            for (int i = 0; i < this.delegates.length; ++i) {
                if (i > 0) {
                    resp.reset();
                }
                this.delegates[i].doGet(req, resp);
                if (resp.getStatus() == 404) continue;
                return;
            }
        }
    }

    static class DoGetOne
    implements DoGetProcessor {
        private StaticServlet delegate;

        DoGetOne(StaticServlet delegate) {
            this.delegate = delegate;
        }

        @Override
        public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.delegate.doGet(req, resp);
        }
    }

    @FunctionalInterface
    static interface DoGetProcessor {
        public void doGet(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
    }
}

